package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PersistentVolumeStatusBuilder extends PersistentVolumeStatusFluentImpl<PersistentVolumeStatusBuilder> implements VisitableBuilder<PersistentVolumeStatus,io.fabric8.kubernetes.api.model.PersistentVolumeStatusBuilder>{
  public PersistentVolumeStatusBuilder() {
    this(false);
  }
  public PersistentVolumeStatusBuilder(Boolean validationEnabled) {
    this(new PersistentVolumeStatus(), validationEnabled);
  }
  public PersistentVolumeStatusBuilder(io.fabric8.kubernetes.api.model.PersistentVolumeStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public PersistentVolumeStatusBuilder(io.fabric8.kubernetes.api.model.PersistentVolumeStatusFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new PersistentVolumeStatus(), validationEnabled);
  }
  public PersistentVolumeStatusBuilder(io.fabric8.kubernetes.api.model.PersistentVolumeStatusFluent<?> fluent,io.fabric8.kubernetes.api.model.PersistentVolumeStatus instance) {
    this(fluent, instance, false);
  }
  public PersistentVolumeStatusBuilder(io.fabric8.kubernetes.api.model.PersistentVolumeStatusFluent<?> fluent,io.fabric8.kubernetes.api.model.PersistentVolumeStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withMessage(instance.getMessage()); 
    fluent.withPhase(instance.getPhase()); 
    fluent.withReason(instance.getReason()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public PersistentVolumeStatusBuilder(io.fabric8.kubernetes.api.model.PersistentVolumeStatus instance) {
    this(instance,false);
  }
  public PersistentVolumeStatusBuilder(io.fabric8.kubernetes.api.model.PersistentVolumeStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withMessage(instance.getMessage()); 
    this.withPhase(instance.getPhase()); 
    this.withReason(instance.getReason()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.PersistentVolumeStatusFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.PersistentVolumeStatus build() {
    PersistentVolumeStatus buildable = new PersistentVolumeStatus(fluent.getMessage(),fluent.getPhase(),fluent.getReason());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}