package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PodAffinityBuilder extends PodAffinityFluentImpl<PodAffinityBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.PodAffinity,io.fabric8.kubernetes.api.model.PodAffinityBuilder>{
  public PodAffinityBuilder() {
    this(false);
  }
  public PodAffinityBuilder(Boolean validationEnabled) {
    this(new PodAffinity(), validationEnabled);
  }
  public PodAffinityBuilder(PodAffinityFluent<?> fluent) {
    this(fluent, false);
  }
  public PodAffinityBuilder(io.fabric8.kubernetes.api.model.PodAffinityFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new PodAffinity(), validationEnabled);
  }
  public PodAffinityBuilder(io.fabric8.kubernetes.api.model.PodAffinityFluent<?> fluent,io.fabric8.kubernetes.api.model.PodAffinity instance) {
    this(fluent, instance, false);
  }
  public PodAffinityBuilder(io.fabric8.kubernetes.api.model.PodAffinityFluent<?> fluent,io.fabric8.kubernetes.api.model.PodAffinity instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withPreferredDuringSchedulingIgnoredDuringExecution(instance.getPreferredDuringSchedulingIgnoredDuringExecution()); 
    fluent.withRequiredDuringSchedulingIgnoredDuringExecution(instance.getRequiredDuringSchedulingIgnoredDuringExecution()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public PodAffinityBuilder(io.fabric8.kubernetes.api.model.PodAffinity instance) {
    this(instance,false);
  }
  public PodAffinityBuilder(io.fabric8.kubernetes.api.model.PodAffinity instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withPreferredDuringSchedulingIgnoredDuringExecution(instance.getPreferredDuringSchedulingIgnoredDuringExecution()); 
    this.withRequiredDuringSchedulingIgnoredDuringExecution(instance.getRequiredDuringSchedulingIgnoredDuringExecution()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.PodAffinityFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.PodAffinity build() {
    PodAffinity buildable = new PodAffinity(fluent.getPreferredDuringSchedulingIgnoredDuringExecution(),fluent.getRequiredDuringSchedulingIgnoredDuringExecution());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}