package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PodAffinityTermBuilder extends PodAffinityTermFluentImpl<PodAffinityTermBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.PodAffinityTerm,io.fabric8.kubernetes.api.model.PodAffinityTermBuilder>{
  public PodAffinityTermBuilder() {
    this(false);
  }
  public PodAffinityTermBuilder(Boolean validationEnabled) {
    this(new PodAffinityTerm(), validationEnabled);
  }
  public PodAffinityTermBuilder(PodAffinityTermFluent<?> fluent) {
    this(fluent, false);
  }
  public PodAffinityTermBuilder(io.fabric8.kubernetes.api.model.PodAffinityTermFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new PodAffinityTerm(), validationEnabled);
  }
  public PodAffinityTermBuilder(io.fabric8.kubernetes.api.model.PodAffinityTermFluent<?> fluent,io.fabric8.kubernetes.api.model.PodAffinityTerm instance) {
    this(fluent, instance, false);
  }
  public PodAffinityTermBuilder(io.fabric8.kubernetes.api.model.PodAffinityTermFluent<?> fluent,io.fabric8.kubernetes.api.model.PodAffinityTerm instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withLabelSelector(instance.getLabelSelector()); 
    fluent.withNamespaceSelector(instance.getNamespaceSelector()); 
    fluent.withNamespaces(instance.getNamespaces()); 
    fluent.withTopologyKey(instance.getTopologyKey()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public PodAffinityTermBuilder(io.fabric8.kubernetes.api.model.PodAffinityTerm instance) {
    this(instance,false);
  }
  public PodAffinityTermBuilder(io.fabric8.kubernetes.api.model.PodAffinityTerm instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withLabelSelector(instance.getLabelSelector()); 
    this.withNamespaceSelector(instance.getNamespaceSelector()); 
    this.withNamespaces(instance.getNamespaces()); 
    this.withTopologyKey(instance.getTopologyKey()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.PodAffinityTermFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.PodAffinityTerm build() {
    PodAffinityTerm buildable = new PodAffinityTerm(fluent.getLabelSelector(),fluent.getNamespaceSelector(),fluent.getNamespaces(),fluent.getTopologyKey());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}