package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PodBuilder extends PodFluentImpl<PodBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.Pod,PodBuilder>{
  public PodBuilder() {
    this(false);
  }
  public PodBuilder(Boolean validationEnabled) {
    this(new Pod(), validationEnabled);
  }
  public PodBuilder(io.fabric8.kubernetes.api.model.PodFluent<?> fluent) {
    this(fluent, false);
  }
  public PodBuilder(io.fabric8.kubernetes.api.model.PodFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new Pod(), validationEnabled);
  }
  public PodBuilder(io.fabric8.kubernetes.api.model.PodFluent<?> fluent,io.fabric8.kubernetes.api.model.Pod instance) {
    this(fluent, instance, false);
  }
  public PodBuilder(io.fabric8.kubernetes.api.model.PodFluent<?> fluent,io.fabric8.kubernetes.api.model.Pod instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withStatus(instance.getStatus()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public PodBuilder(io.fabric8.kubernetes.api.model.Pod instance) {
    this(instance,false);
  }
  public PodBuilder(io.fabric8.kubernetes.api.model.Pod instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.PodFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.Pod build() {
    Pod buildable = new Pod(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}