package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PodConditionBuilder extends PodConditionFluentImpl<PodConditionBuilder> implements VisitableBuilder<PodCondition,io.fabric8.kubernetes.api.model.PodConditionBuilder>{
  public PodConditionBuilder() {
    this(false);
  }
  public PodConditionBuilder(Boolean validationEnabled) {
    this(new PodCondition(), validationEnabled);
  }
  public PodConditionBuilder(io.fabric8.kubernetes.api.model.PodConditionFluent<?> fluent) {
    this(fluent, false);
  }
  public PodConditionBuilder(io.fabric8.kubernetes.api.model.PodConditionFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new PodCondition(), validationEnabled);
  }
  public PodConditionBuilder(io.fabric8.kubernetes.api.model.PodConditionFluent<?> fluent,io.fabric8.kubernetes.api.model.PodCondition instance) {
    this(fluent, instance, false);
  }
  public PodConditionBuilder(io.fabric8.kubernetes.api.model.PodConditionFluent<?> fluent,io.fabric8.kubernetes.api.model.PodCondition instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withLastProbeTime(instance.getLastProbeTime()); 
    fluent.withLastTransitionTime(instance.getLastTransitionTime()); 
    fluent.withMessage(instance.getMessage()); 
    fluent.withReason(instance.getReason()); 
    fluent.withStatus(instance.getStatus()); 
    fluent.withType(instance.getType()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public PodConditionBuilder(io.fabric8.kubernetes.api.model.PodCondition instance) {
    this(instance,false);
  }
  public PodConditionBuilder(io.fabric8.kubernetes.api.model.PodCondition instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withLastProbeTime(instance.getLastProbeTime()); 
    this.withLastTransitionTime(instance.getLastTransitionTime()); 
    this.withMessage(instance.getMessage()); 
    this.withReason(instance.getReason()); 
    this.withStatus(instance.getStatus()); 
    this.withType(instance.getType()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.PodConditionFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.PodCondition build() {
    PodCondition buildable = new PodCondition(fluent.getLastProbeTime(),fluent.getLastTransitionTime(),fluent.getMessage(),fluent.getReason(),fluent.getStatus(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}