package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PodDNSConfigBuilder extends PodDNSConfigFluentImpl<PodDNSConfigBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.PodDNSConfig,PodDNSConfigBuilder>{
  public PodDNSConfigBuilder() {
    this(false);
  }
  public PodDNSConfigBuilder(Boolean validationEnabled) {
    this(new PodDNSConfig(), validationEnabled);
  }
  public PodDNSConfigBuilder(io.fabric8.kubernetes.api.model.PodDNSConfigFluent<?> fluent) {
    this(fluent, false);
  }
  public PodDNSConfigBuilder(io.fabric8.kubernetes.api.model.PodDNSConfigFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new PodDNSConfig(), validationEnabled);
  }
  public PodDNSConfigBuilder(io.fabric8.kubernetes.api.model.PodDNSConfigFluent<?> fluent,io.fabric8.kubernetes.api.model.PodDNSConfig instance) {
    this(fluent, instance, false);
  }
  public PodDNSConfigBuilder(io.fabric8.kubernetes.api.model.PodDNSConfigFluent<?> fluent,io.fabric8.kubernetes.api.model.PodDNSConfig instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withNameservers(instance.getNameservers()); 
    fluent.withOptions(instance.getOptions()); 
    fluent.withSearches(instance.getSearches()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public PodDNSConfigBuilder(io.fabric8.kubernetes.api.model.PodDNSConfig instance) {
    this(instance,false);
  }
  public PodDNSConfigBuilder(io.fabric8.kubernetes.api.model.PodDNSConfig instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withNameservers(instance.getNameservers()); 
    this.withOptions(instance.getOptions()); 
    this.withSearches(instance.getSearches()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.PodDNSConfigFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.PodDNSConfig build() {
    PodDNSConfig buildable = new PodDNSConfig(fluent.getNameservers(),fluent.getOptions(),fluent.getSearches());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}