package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PodDNSConfigOptionBuilder extends PodDNSConfigOptionFluentImpl<PodDNSConfigOptionBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.PodDNSConfigOption,PodDNSConfigOptionBuilder>{
  public PodDNSConfigOptionBuilder() {
    this(false);
  }
  public PodDNSConfigOptionBuilder(Boolean validationEnabled) {
    this(new PodDNSConfigOption(), validationEnabled);
  }
  public PodDNSConfigOptionBuilder(PodDNSConfigOptionFluent<?> fluent) {
    this(fluent, false);
  }
  public PodDNSConfigOptionBuilder(io.fabric8.kubernetes.api.model.PodDNSConfigOptionFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new PodDNSConfigOption(), validationEnabled);
  }
  public PodDNSConfigOptionBuilder(io.fabric8.kubernetes.api.model.PodDNSConfigOptionFluent<?> fluent,io.fabric8.kubernetes.api.model.PodDNSConfigOption instance) {
    this(fluent, instance, false);
  }
  public PodDNSConfigOptionBuilder(io.fabric8.kubernetes.api.model.PodDNSConfigOptionFluent<?> fluent,io.fabric8.kubernetes.api.model.PodDNSConfigOption instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withName(instance.getName()); 
    fluent.withValue(instance.getValue()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public PodDNSConfigOptionBuilder(io.fabric8.kubernetes.api.model.PodDNSConfigOption instance) {
    this(instance,false);
  }
  public PodDNSConfigOptionBuilder(io.fabric8.kubernetes.api.model.PodDNSConfigOption instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withName(instance.getName()); 
    this.withValue(instance.getValue()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.PodDNSConfigOptionFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.PodDNSConfigOption build() {
    PodDNSConfigOption buildable = new PodDNSConfigOption(fluent.getName(),fluent.getValue());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}