package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PodExecOptionsBuilder extends PodExecOptionsFluentImpl<PodExecOptionsBuilder> implements VisitableBuilder<PodExecOptions,io.fabric8.kubernetes.api.model.PodExecOptionsBuilder>{
  public PodExecOptionsBuilder() {
    this(false);
  }
  public PodExecOptionsBuilder(Boolean validationEnabled) {
    this(new PodExecOptions(), validationEnabled);
  }
  public PodExecOptionsBuilder(PodExecOptionsFluent<?> fluent) {
    this(fluent, false);
  }
  public PodExecOptionsBuilder(io.fabric8.kubernetes.api.model.PodExecOptionsFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new PodExecOptions(), validationEnabled);
  }
  public PodExecOptionsBuilder(io.fabric8.kubernetes.api.model.PodExecOptionsFluent<?> fluent,io.fabric8.kubernetes.api.model.PodExecOptions instance) {
    this(fluent, instance, false);
  }
  public PodExecOptionsBuilder(io.fabric8.kubernetes.api.model.PodExecOptionsFluent<?> fluent,io.fabric8.kubernetes.api.model.PodExecOptions instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withCommand(instance.getCommand()); 
    fluent.withContainer(instance.getContainer()); 
    fluent.withKind(instance.getKind()); 
    fluent.withStderr(instance.getStderr()); 
    fluent.withStdin(instance.getStdin()); 
    fluent.withStdout(instance.getStdout()); 
    fluent.withTty(instance.getTty()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public PodExecOptionsBuilder(io.fabric8.kubernetes.api.model.PodExecOptions instance) {
    this(instance,false);
  }
  public PodExecOptionsBuilder(io.fabric8.kubernetes.api.model.PodExecOptions instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withCommand(instance.getCommand()); 
    this.withContainer(instance.getContainer()); 
    this.withKind(instance.getKind()); 
    this.withStderr(instance.getStderr()); 
    this.withStdin(instance.getStdin()); 
    this.withStdout(instance.getStdout()); 
    this.withTty(instance.getTty()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.PodExecOptionsFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.PodExecOptions build() {
    PodExecOptions buildable = new PodExecOptions(fluent.getApiVersion(),fluent.getCommand(),fluent.getContainer(),fluent.getKind(),fluent.getStderr(),fluent.getStdin(),fluent.getStdout(),fluent.getTty());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}