package io.fabric8.kubernetes.api.model;

import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class PodExecOptionsFluentImpl<A extends PodExecOptionsFluent<A>> extends BaseFluent<A> implements PodExecOptionsFluent<A>{
  public PodExecOptionsFluentImpl() {
  }
  public PodExecOptionsFluentImpl(io.fabric8.kubernetes.api.model.PodExecOptions instance) {
    this.withApiVersion(instance.getApiVersion()); 
    this.withCommand(instance.getCommand()); 
    this.withContainer(instance.getContainer()); 
    this.withKind(instance.getKind()); 
    this.withStderr(instance.getStderr()); 
    this.withStdin(instance.getStdin()); 
    this.withStdout(instance.getStdout()); 
    this.withTty(instance.getTty()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private String apiVersion;
  private List<java.lang.String> command = new ArrayList<java.lang.String>();
  private java.lang.String container;
  private java.lang.String kind;
  private Boolean stderr;
  private java.lang.Boolean stdin;
  private java.lang.Boolean stdout;
  private java.lang.Boolean tty;
  private Map<java.lang.String,Object> additionalProperties;
  public java.lang.String getApiVersion() {
    return this.apiVersion;
  }
  public A withApiVersion(java.lang.String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  public java.lang.Boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  public A addToCommand(Integer index,java.lang.String item) {
    if (this.command == null) {this.command = new java.util.ArrayList<java.lang.String>();}
    this.command.add(index, item);
    return (A)this;
  }
  public A setToCommand(java.lang.Integer index,java.lang.String item) {
    if (this.command == null) {this.command = new java.util.ArrayList<java.lang.String>();}
    this.command.set(index, item); return (A)this;
  }
  public A addToCommand(java.lang.String... items) {
    if (this.command == null) {this.command = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.command.add(item);} return (A)this;
  }
  public A addAllToCommand(Collection<java.lang.String> items) {
    if (this.command == null) {this.command = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.command.add(item);} return (A)this;
  }
  public A removeFromCommand(java.lang.String... items) {
    for (java.lang.String item : items) {if (this.command!= null){ this.command.remove(item);}} return (A)this;
  }
  public A removeAllFromCommand(java.util.Collection<java.lang.String> items) {
    for (java.lang.String item : items) {if (this.command!= null){ this.command.remove(item);}} return (A)this;
  }
  public java.util.List<java.lang.String> getCommand() {
    return this.command;
  }
  public java.lang.String getCommand(java.lang.Integer index) {
    return this.command.get(index);
  }
  public java.lang.String getFirstCommand() {
    return this.command.get(0);
  }
  public java.lang.String getLastCommand() {
    return this.command.get(command.size() - 1);
  }
  public java.lang.String getMatchingCommand(Predicate<java.lang.String> predicate) {
    for (java.lang.String item: command) { if(predicate.test(item)){ return item;} } return null;
  }
  public java.lang.Boolean hasMatchingCommand(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: command) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withCommand(java.util.List<java.lang.String> command) {
    if (command != null) {this.command = new java.util.ArrayList(); for (java.lang.String item : command){this.addToCommand(item);}} else { this.command = null;} return (A) this;
  }
  public A withCommand(java.lang.String... command) {
    if (this.command != null) {this.command.clear();}
    if (command != null) {for (java.lang.String item :command){ this.addToCommand(item);}} return (A) this;
  }
  public java.lang.Boolean hasCommand() {
    return command != null && !command.isEmpty();
  }
  public java.lang.String getContainer() {
    return this.container;
  }
  public A withContainer(java.lang.String container) {
    this.container=container; return (A) this;
  }
  public java.lang.Boolean hasContainer() {
    return this.container != null;
  }
  public java.lang.String getKind() {
    return this.kind;
  }
  public A withKind(java.lang.String kind) {
    this.kind=kind; return (A) this;
  }
  public java.lang.Boolean hasKind() {
    return this.kind != null;
  }
  public java.lang.Boolean getStderr() {
    return this.stderr;
  }
  public A withStderr(java.lang.Boolean stderr) {
    this.stderr=stderr; return (A) this;
  }
  public java.lang.Boolean hasStderr() {
    return this.stderr != null;
  }
  public java.lang.Boolean getStdin() {
    return this.stdin;
  }
  public A withStdin(java.lang.Boolean stdin) {
    this.stdin=stdin; return (A) this;
  }
  public java.lang.Boolean hasStdin() {
    return this.stdin != null;
  }
  public java.lang.Boolean getStdout() {
    return this.stdout;
  }
  public A withStdout(java.lang.Boolean stdout) {
    this.stdout=stdout; return (A) this;
  }
  public java.lang.Boolean hasStdout() {
    return this.stdout != null;
  }
  public java.lang.Boolean getTty() {
    return this.tty;
  }
  public A withTty(java.lang.Boolean tty) {
    this.tty=tty; return (A) this;
  }
  public java.lang.Boolean hasTty() {
    return this.tty != null;
  }
  public A addToAdditionalProperties(java.lang.String key,java.lang.Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new java.util.LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.lang.String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new java.util.LinkedHashMap(additionalProperties);} return (A) this;
  }
  public java.lang.Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    PodExecOptionsFluentImpl that = (PodExecOptionsFluentImpl) o;
    if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
    if (command != null ? !command.equals(that.command) :that.command != null) return false;
    if (container != null ? !container.equals(that.container) :that.container != null) return false;
    if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
    if (stderr != null ? !stderr.equals(that.stderr) :that.stderr != null) return false;
    if (stdin != null ? !stdin.equals(that.stdin) :that.stdin != null) return false;
    if (stdout != null ? !stdout.equals(that.stdout) :that.stdout != null) return false;
    if (tty != null ? !tty.equals(that.tty) :that.tty != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  command,  container,  kind,  stderr,  stdin,  stdout,  tty,  additionalProperties,  super.hashCode());
  }
  public java.lang.String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (command != null && !command.isEmpty()) { sb.append("command:"); sb.append(command + ","); }
    if (container != null) { sb.append("container:"); sb.append(container + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (stderr != null) { sb.append("stderr:"); sb.append(stderr + ","); }
    if (stdin != null) { sb.append("stdin:"); sb.append(stdin + ","); }
    if (stdout != null) { sb.append("stdout:"); sb.append(stdout + ","); }
    if (tty != null) { sb.append("tty:"); sb.append(tty + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public A withStderr() {
    return withStderr(true);
  }
  public A withStdin() {
    return withStdin(true);
  }
  public A withStdout() {
    return withStdout(true);
  }
  public A withTty() {
    return withTty(true);
  }
  
}