package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PodIPBuilder extends PodIPFluentImpl<PodIPBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.PodIP,io.fabric8.kubernetes.api.model.PodIPBuilder>{
  public PodIPBuilder() {
    this(false);
  }
  public PodIPBuilder(Boolean validationEnabled) {
    this(new PodIP(), validationEnabled);
  }
  public PodIPBuilder(PodIPFluent<?> fluent) {
    this(fluent, false);
  }
  public PodIPBuilder(io.fabric8.kubernetes.api.model.PodIPFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new PodIP(), validationEnabled);
  }
  public PodIPBuilder(io.fabric8.kubernetes.api.model.PodIPFluent<?> fluent,io.fabric8.kubernetes.api.model.PodIP instance) {
    this(fluent, instance, false);
  }
  public PodIPBuilder(io.fabric8.kubernetes.api.model.PodIPFluent<?> fluent,io.fabric8.kubernetes.api.model.PodIP instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withIp(instance.getIp()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public PodIPBuilder(io.fabric8.kubernetes.api.model.PodIP instance) {
    this(instance,false);
  }
  public PodIPBuilder(io.fabric8.kubernetes.api.model.PodIP instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withIp(instance.getIp()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.PodIPFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.PodIP build() {
    PodIP buildable = new PodIP(fluent.getIp());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}