package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PodListBuilder extends PodListFluentImpl<PodListBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.PodList,io.fabric8.kubernetes.api.model.PodListBuilder>{
  public PodListBuilder() {
    this(false);
  }
  public PodListBuilder(Boolean validationEnabled) {
    this(new PodList(), validationEnabled);
  }
  public PodListBuilder(PodListFluent<?> fluent) {
    this(fluent, false);
  }
  public PodListBuilder(io.fabric8.kubernetes.api.model.PodListFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new PodList(), validationEnabled);
  }
  public PodListBuilder(io.fabric8.kubernetes.api.model.PodListFluent<?> fluent,io.fabric8.kubernetes.api.model.PodList instance) {
    this(fluent, instance, false);
  }
  public PodListBuilder(io.fabric8.kubernetes.api.model.PodListFluent<?> fluent,io.fabric8.kubernetes.api.model.PodList instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public PodListBuilder(io.fabric8.kubernetes.api.model.PodList instance) {
    this(instance,false);
  }
  public PodListBuilder(io.fabric8.kubernetes.api.model.PodList instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.PodListFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.PodList build() {
    PodList buildable = new PodList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}