package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PodOSBuilder extends PodOSFluentImpl<PodOSBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.PodOS,io.fabric8.kubernetes.api.model.PodOSBuilder>{
  public PodOSBuilder() {
    this(false);
  }
  public PodOSBuilder(Boolean validationEnabled) {
    this(new PodOS(), validationEnabled);
  }
  public PodOSBuilder(PodOSFluent<?> fluent) {
    this(fluent, false);
  }
  public PodOSBuilder(io.fabric8.kubernetes.api.model.PodOSFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new PodOS(), validationEnabled);
  }
  public PodOSBuilder(io.fabric8.kubernetes.api.model.PodOSFluent<?> fluent,io.fabric8.kubernetes.api.model.PodOS instance) {
    this(fluent, instance, false);
  }
  public PodOSBuilder(io.fabric8.kubernetes.api.model.PodOSFluent<?> fluent,io.fabric8.kubernetes.api.model.PodOS instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withName(instance.getName()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public PodOSBuilder(io.fabric8.kubernetes.api.model.PodOS instance) {
    this(instance,false);
  }
  public PodOSBuilder(io.fabric8.kubernetes.api.model.PodOS instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withName(instance.getName()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.PodOSFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.PodOS build() {
    PodOS buildable = new PodOS(fluent.getName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}