package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PodReadinessGateBuilder extends PodReadinessGateFluentImpl<PodReadinessGateBuilder> implements VisitableBuilder<PodReadinessGate,io.fabric8.kubernetes.api.model.PodReadinessGateBuilder>{
  public PodReadinessGateBuilder() {
    this(false);
  }
  public PodReadinessGateBuilder(Boolean validationEnabled) {
    this(new PodReadinessGate(), validationEnabled);
  }
  public PodReadinessGateBuilder(io.fabric8.kubernetes.api.model.PodReadinessGateFluent<?> fluent) {
    this(fluent, false);
  }
  public PodReadinessGateBuilder(io.fabric8.kubernetes.api.model.PodReadinessGateFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new PodReadinessGate(), validationEnabled);
  }
  public PodReadinessGateBuilder(io.fabric8.kubernetes.api.model.PodReadinessGateFluent<?> fluent,io.fabric8.kubernetes.api.model.PodReadinessGate instance) {
    this(fluent, instance, false);
  }
  public PodReadinessGateBuilder(io.fabric8.kubernetes.api.model.PodReadinessGateFluent<?> fluent,io.fabric8.kubernetes.api.model.PodReadinessGate instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withConditionType(instance.getConditionType()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public PodReadinessGateBuilder(io.fabric8.kubernetes.api.model.PodReadinessGate instance) {
    this(instance,false);
  }
  public PodReadinessGateBuilder(io.fabric8.kubernetes.api.model.PodReadinessGate instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withConditionType(instance.getConditionType()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.PodReadinessGateFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.PodReadinessGate build() {
    PodReadinessGate buildable = new PodReadinessGate(fluent.getConditionType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}