package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.Deprecated;
import java.util.Iterator;
import java.lang.Integer;

 /**
  * Generated
  */
public interface PodSpecFluent<A extends PodSpecFluent<A>> extends Fluent<A>{
  public Long getActiveDeadlineSeconds();
  public A withActiveDeadlineSeconds(java.lang.Long activeDeadlineSeconds);
  public Boolean hasActiveDeadlineSeconds();
  
  /**
   * This method has been deprecated, please use method buildAffinity instead.
   * @return The buildable object.
   */
  @Deprecated
  public Affinity getAffinity();
  public io.fabric8.kubernetes.api.model.Affinity buildAffinity();
  public A withAffinity(io.fabric8.kubernetes.api.model.Affinity affinity);
  public java.lang.Boolean hasAffinity();
  public PodSpecFluent.AffinityNested<A> withNewAffinity();
  public io.fabric8.kubernetes.api.model.PodSpecFluent.AffinityNested<A> withNewAffinityLike(io.fabric8.kubernetes.api.model.Affinity item);
  public io.fabric8.kubernetes.api.model.PodSpecFluent.AffinityNested<A> editAffinity();
  public io.fabric8.kubernetes.api.model.PodSpecFluent.AffinityNested<A> editOrNewAffinity();
  public io.fabric8.kubernetes.api.model.PodSpecFluent.AffinityNested<A> editOrNewAffinityLike(io.fabric8.kubernetes.api.model.Affinity item);
  public java.lang.Boolean getAutomountServiceAccountToken();
  public A withAutomountServiceAccountToken(java.lang.Boolean automountServiceAccountToken);
  public java.lang.Boolean hasAutomountServiceAccountToken();
  public A addToContainers(Integer index,Container item);
  public A setToContainers(java.lang.Integer index,io.fabric8.kubernetes.api.model.Container item);
  public A addToContainers(io.fabric8.kubernetes.api.model.Container... items);
  public A addAllToContainers(Collection<io.fabric8.kubernetes.api.model.Container> items);
  public A removeFromContainers(io.fabric8.kubernetes.api.model.Container... items);
  public A removeAllFromContainers(java.util.Collection<io.fabric8.kubernetes.api.model.Container> items);
  public A removeMatchingFromContainers(Predicate<ContainerBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildContainers instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public List<io.fabric8.kubernetes.api.model.Container> getContainers();
  public java.util.List<io.fabric8.kubernetes.api.model.Container> buildContainers();
  public io.fabric8.kubernetes.api.model.Container buildContainer(java.lang.Integer index);
  public io.fabric8.kubernetes.api.model.Container buildFirstContainer();
  public io.fabric8.kubernetes.api.model.Container buildLastContainer();
  public io.fabric8.kubernetes.api.model.Container buildMatchingContainer(java.util.function.Predicate<io.fabric8.kubernetes.api.model.ContainerBuilder> predicate);
  public java.lang.Boolean hasMatchingContainer(java.util.function.Predicate<io.fabric8.kubernetes.api.model.ContainerBuilder> predicate);
  public A withContainers(java.util.List<io.fabric8.kubernetes.api.model.Container> containers);
  public A withContainers(io.fabric8.kubernetes.api.model.Container... containers);
  public java.lang.Boolean hasContainers();
  public PodSpecFluent.ContainersNested<A> addNewContainer();
  public io.fabric8.kubernetes.api.model.PodSpecFluent.ContainersNested<A> addNewContainerLike(io.fabric8.kubernetes.api.model.Container item);
  public io.fabric8.kubernetes.api.model.PodSpecFluent.ContainersNested<A> setNewContainerLike(java.lang.Integer index,io.fabric8.kubernetes.api.model.Container item);
  public io.fabric8.kubernetes.api.model.PodSpecFluent.ContainersNested<A> editContainer(java.lang.Integer index);
  public io.fabric8.kubernetes.api.model.PodSpecFluent.ContainersNested<A> editFirstContainer();
  public io.fabric8.kubernetes.api.model.PodSpecFluent.ContainersNested<A> editLastContainer();
  public io.fabric8.kubernetes.api.model.PodSpecFluent.ContainersNested<A> editMatchingContainer(java.util.function.Predicate<io.fabric8.kubernetes.api.model.ContainerBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildDnsConfig instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public PodDNSConfig getDnsConfig();
  public io.fabric8.kubernetes.api.model.PodDNSConfig buildDnsConfig();
  public A withDnsConfig(io.fabric8.kubernetes.api.model.PodDNSConfig dnsConfig);
  public java.lang.Boolean hasDnsConfig();
  public PodSpecFluent.DnsConfigNested<A> withNewDnsConfig();
  public io.fabric8.kubernetes.api.model.PodSpecFluent.DnsConfigNested<A> withNewDnsConfigLike(io.fabric8.kubernetes.api.model.PodDNSConfig item);
  public io.fabric8.kubernetes.api.model.PodSpecFluent.DnsConfigNested<A> editDnsConfig();
  public io.fabric8.kubernetes.api.model.PodSpecFluent.DnsConfigNested<A> editOrNewDnsConfig();
  public io.fabric8.kubernetes.api.model.PodSpecFluent.DnsConfigNested<A> editOrNewDnsConfigLike(io.fabric8.kubernetes.api.model.PodDNSConfig item);
  public String getDnsPolicy();
  public A withDnsPolicy(java.lang.String dnsPolicy);
  public java.lang.Boolean hasDnsPolicy();
  public java.lang.Boolean getEnableServiceLinks();
  public A withEnableServiceLinks(java.lang.Boolean enableServiceLinks);
  public java.lang.Boolean hasEnableServiceLinks();
  public A addToEphemeralContainers(java.lang.Integer index,EphemeralContainer item);
  public A setToEphemeralContainers(java.lang.Integer index,io.fabric8.kubernetes.api.model.EphemeralContainer item);
  public A addToEphemeralContainers(io.fabric8.kubernetes.api.model.EphemeralContainer... items);
  public A addAllToEphemeralContainers(java.util.Collection<io.fabric8.kubernetes.api.model.EphemeralContainer> items);
  public A removeFromEphemeralContainers(io.fabric8.kubernetes.api.model.EphemeralContainer... items);
  public A removeAllFromEphemeralContainers(java.util.Collection<io.fabric8.kubernetes.api.model.EphemeralContainer> items);
  public A removeMatchingFromEphemeralContainers(java.util.function.Predicate<EphemeralContainerBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildEphemeralContainers instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public java.util.List<io.fabric8.kubernetes.api.model.EphemeralContainer> getEphemeralContainers();
  public java.util.List<io.fabric8.kubernetes.api.model.EphemeralContainer> buildEphemeralContainers();
  public io.fabric8.kubernetes.api.model.EphemeralContainer buildEphemeralContainer(java.lang.Integer index);
  public io.fabric8.kubernetes.api.model.EphemeralContainer buildFirstEphemeralContainer();
  public io.fabric8.kubernetes.api.model.EphemeralContainer buildLastEphemeralContainer();
  public io.fabric8.kubernetes.api.model.EphemeralContainer buildMatchingEphemeralContainer(java.util.function.Predicate<io.fabric8.kubernetes.api.model.EphemeralContainerBuilder> predicate);
  public java.lang.Boolean hasMatchingEphemeralContainer(java.util.function.Predicate<io.fabric8.kubernetes.api.model.EphemeralContainerBuilder> predicate);
  public A withEphemeralContainers(java.util.List<io.fabric8.kubernetes.api.model.EphemeralContainer> ephemeralContainers);
  public A withEphemeralContainers(io.fabric8.kubernetes.api.model.EphemeralContainer... ephemeralContainers);
  public java.lang.Boolean hasEphemeralContainers();
  public PodSpecFluent.EphemeralContainersNested<A> addNewEphemeralContainer();
  public io.fabric8.kubernetes.api.model.PodSpecFluent.EphemeralContainersNested<A> addNewEphemeralContainerLike(io.fabric8.kubernetes.api.model.EphemeralContainer item);
  public io.fabric8.kubernetes.api.model.PodSpecFluent.EphemeralContainersNested<A> setNewEphemeralContainerLike(java.lang.Integer index,io.fabric8.kubernetes.api.model.EphemeralContainer item);
  public io.fabric8.kubernetes.api.model.PodSpecFluent.EphemeralContainersNested<A> editEphemeralContainer(java.lang.Integer index);
  public io.fabric8.kubernetes.api.model.PodSpecFluent.EphemeralContainersNested<A> editFirstEphemeralContainer();
  public io.fabric8.kubernetes.api.model.PodSpecFluent.EphemeralContainersNested<A> editLastEphemeralContainer();
  public io.fabric8.kubernetes.api.model.PodSpecFluent.EphemeralContainersNested<A> editMatchingEphemeralContainer(java.util.function.Predicate<io.fabric8.kubernetes.api.model.EphemeralContainerBuilder> predicate);
  public A addToHostAliases(java.lang.Integer index,HostAlias item);
  public A setToHostAliases(java.lang.Integer index,io.fabric8.kubernetes.api.model.HostAlias item);
  public A addToHostAliases(io.fabric8.kubernetes.api.model.HostAlias... items);
  public A addAllToHostAliases(java.util.Collection<io.fabric8.kubernetes.api.model.HostAlias> items);
  public A removeFromHostAliases(io.fabric8.kubernetes.api.model.HostAlias... items);
  public A removeAllFromHostAliases(java.util.Collection<io.fabric8.kubernetes.api.model.HostAlias> items);
  public A removeMatchingFromHostAliases(java.util.function.Predicate<HostAliasBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildHostAliases instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public java.util.List<io.fabric8.kubernetes.api.model.HostAlias> getHostAliases();
  public java.util.List<io.fabric8.kubernetes.api.model.HostAlias> buildHostAliases();
  public io.fabric8.kubernetes.api.model.HostAlias buildHostAlias(java.lang.Integer index);
  public io.fabric8.kubernetes.api.model.HostAlias buildFirstHostAlias();
  public io.fabric8.kubernetes.api.model.HostAlias buildLastHostAlias();
  public io.fabric8.kubernetes.api.model.HostAlias buildMatchingHostAlias(java.util.function.Predicate<io.fabric8.kubernetes.api.model.HostAliasBuilder> predicate);
  public java.lang.Boolean hasMatchingHostAlias(java.util.function.Predicate<io.fabric8.kubernetes.api.model.HostAliasBuilder> predicate);
  public A withHostAliases(java.util.List<io.fabric8.kubernetes.api.model.HostAlias> hostAliases);
  public A withHostAliases(io.fabric8.kubernetes.api.model.HostAlias... hostAliases);
  public java.lang.Boolean hasHostAliases();
  public PodSpecFluent.HostAliasesNested<A> addNewHostAlias();
  public io.fabric8.kubernetes.api.model.PodSpecFluent.HostAliasesNested<A> addNewHostAliasLike(io.fabric8.kubernetes.api.model.HostAlias item);
  public io.fabric8.kubernetes.api.model.PodSpecFluent.HostAliasesNested<A> setNewHostAliasLike(java.lang.Integer index,io.fabric8.kubernetes.api.model.HostAlias item);
  public io.fabric8.kubernetes.api.model.PodSpecFluent.HostAliasesNested<A> editHostAlias(java.lang.Integer index);
  public io.fabric8.kubernetes.api.model.PodSpecFluent.HostAliasesNested<A> editFirstHostAlias();
  public io.fabric8.kubernetes.api.model.PodSpecFluent.HostAliasesNested<A> editLastHostAlias();
  public io.fabric8.kubernetes.api.model.PodSpecFluent.HostAliasesNested<A> editMatchingHostAlias(java.util.function.Predicate<io.fabric8.kubernetes.api.model.HostAliasBuilder> predicate);
  public java.lang.Boolean getHostIPC();
  public A withHostIPC(java.lang.Boolean hostIPC);
  public java.lang.Boolean hasHostIPC();
  public java.lang.Boolean getHostNetwork();
  public A withHostNetwork(java.lang.Boolean hostNetwork);
  public java.lang.Boolean hasHostNetwork();
  public java.lang.Boolean getHostPID();
  public A withHostPID(java.lang.Boolean hostPID);
  public java.lang.Boolean hasHostPID();
  public java.lang.String getHostname();
  public A withHostname(java.lang.String hostname);
  public java.lang.Boolean hasHostname();
  public A addToImagePullSecrets(java.lang.Integer index,LocalObjectReference item);
  public A setToImagePullSecrets(java.lang.Integer index,io.fabric8.kubernetes.api.model.LocalObjectReference item);
  public A addToImagePullSecrets(io.fabric8.kubernetes.api.model.LocalObjectReference... items);
  public A addAllToImagePullSecrets(java.util.Collection<io.fabric8.kubernetes.api.model.LocalObjectReference> items);
  public A removeFromImagePullSecrets(io.fabric8.kubernetes.api.model.LocalObjectReference... items);
  public A removeAllFromImagePullSecrets(java.util.Collection<io.fabric8.kubernetes.api.model.LocalObjectReference> items);
  public A removeMatchingFromImagePullSecrets(java.util.function.Predicate<LocalObjectReferenceBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildImagePullSecrets instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public java.util.List<io.fabric8.kubernetes.api.model.LocalObjectReference> getImagePullSecrets();
  public java.util.List<io.fabric8.kubernetes.api.model.LocalObjectReference> buildImagePullSecrets();
  public io.fabric8.kubernetes.api.model.LocalObjectReference buildImagePullSecret(java.lang.Integer index);
  public io.fabric8.kubernetes.api.model.LocalObjectReference buildFirstImagePullSecret();
  public io.fabric8.kubernetes.api.model.LocalObjectReference buildLastImagePullSecret();
  public io.fabric8.kubernetes.api.model.LocalObjectReference buildMatchingImagePullSecret(java.util.function.Predicate<io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder> predicate);
  public java.lang.Boolean hasMatchingImagePullSecret(java.util.function.Predicate<io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder> predicate);
  public A withImagePullSecrets(java.util.List<io.fabric8.kubernetes.api.model.LocalObjectReference> imagePullSecrets);
  public A withImagePullSecrets(io.fabric8.kubernetes.api.model.LocalObjectReference... imagePullSecrets);
  public java.lang.Boolean hasImagePullSecrets();
  public A addNewImagePullSecret(java.lang.String name);
  public PodSpecFluent.ImagePullSecretsNested<A> addNewImagePullSecret();
  public io.fabric8.kubernetes.api.model.PodSpecFluent.ImagePullSecretsNested<A> addNewImagePullSecretLike(io.fabric8.kubernetes.api.model.LocalObjectReference item);
  public io.fabric8.kubernetes.api.model.PodSpecFluent.ImagePullSecretsNested<A> setNewImagePullSecretLike(java.lang.Integer index,io.fabric8.kubernetes.api.model.LocalObjectReference item);
  public io.fabric8.kubernetes.api.model.PodSpecFluent.ImagePullSecretsNested<A> editImagePullSecret(java.lang.Integer index);
  public io.fabric8.kubernetes.api.model.PodSpecFluent.ImagePullSecretsNested<A> editFirstImagePullSecret();
  public io.fabric8.kubernetes.api.model.PodSpecFluent.ImagePullSecretsNested<A> editLastImagePullSecret();
  public io.fabric8.kubernetes.api.model.PodSpecFluent.ImagePullSecretsNested<A> editMatchingImagePullSecret(java.util.function.Predicate<io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder> predicate);
  public A addToInitContainers(java.lang.Integer index,io.fabric8.kubernetes.api.model.Container item);
  public A setToInitContainers(java.lang.Integer index,io.fabric8.kubernetes.api.model.Container item);
  public A addToInitContainers(io.fabric8.kubernetes.api.model.Container... items);
  public A addAllToInitContainers(java.util.Collection<io.fabric8.kubernetes.api.model.Container> items);
  public A removeFromInitContainers(io.fabric8.kubernetes.api.model.Container... items);
  public A removeAllFromInitContainers(java.util.Collection<io.fabric8.kubernetes.api.model.Container> items);
  public A removeMatchingFromInitContainers(java.util.function.Predicate<io.fabric8.kubernetes.api.model.ContainerBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildInitContainers instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public java.util.List<io.fabric8.kubernetes.api.model.Container> getInitContainers();
  public java.util.List<io.fabric8.kubernetes.api.model.Container> buildInitContainers();
  public io.fabric8.kubernetes.api.model.Container buildInitContainer(java.lang.Integer index);
  public io.fabric8.kubernetes.api.model.Container buildFirstInitContainer();
  public io.fabric8.kubernetes.api.model.Container buildLastInitContainer();
  public io.fabric8.kubernetes.api.model.Container buildMatchingInitContainer(java.util.function.Predicate<io.fabric8.kubernetes.api.model.ContainerBuilder> predicate);
  public java.lang.Boolean hasMatchingInitContainer(java.util.function.Predicate<io.fabric8.kubernetes.api.model.ContainerBuilder> predicate);
  public A withInitContainers(java.util.List<io.fabric8.kubernetes.api.model.Container> initContainers);
  public A withInitContainers(io.fabric8.kubernetes.api.model.Container... initContainers);
  public java.lang.Boolean hasInitContainers();
  public PodSpecFluent.InitContainersNested<A> addNewInitContainer();
  public io.fabric8.kubernetes.api.model.PodSpecFluent.InitContainersNested<A> addNewInitContainerLike(io.fabric8.kubernetes.api.model.Container item);
  public io.fabric8.kubernetes.api.model.PodSpecFluent.InitContainersNested<A> setNewInitContainerLike(java.lang.Integer index,io.fabric8.kubernetes.api.model.Container item);
  public io.fabric8.kubernetes.api.model.PodSpecFluent.InitContainersNested<A> editInitContainer(java.lang.Integer index);
  public io.fabric8.kubernetes.api.model.PodSpecFluent.InitContainersNested<A> editFirstInitContainer();
  public io.fabric8.kubernetes.api.model.PodSpecFluent.InitContainersNested<A> editLastInitContainer();
  public io.fabric8.kubernetes.api.model.PodSpecFluent.InitContainersNested<A> editMatchingInitContainer(java.util.function.Predicate<io.fabric8.kubernetes.api.model.ContainerBuilder> predicate);
  public java.lang.String getNodeName();
  public A withNodeName(java.lang.String nodeName);
  public java.lang.Boolean hasNodeName();
  public A addToNodeSelector(java.lang.String key,java.lang.String value);
  public A addToNodeSelector(Map<java.lang.String,java.lang.String> map);
  public A removeFromNodeSelector(java.lang.String key);
  public A removeFromNodeSelector(java.util.Map<java.lang.String,java.lang.String> map);
  public java.util.Map<java.lang.String,java.lang.String> getNodeSelector();
  public <K,V>A withNodeSelector(java.util.Map<java.lang.String,java.lang.String> nodeSelector);
  public java.lang.Boolean hasNodeSelector();
  
  /**
   * This method has been deprecated, please use method buildOs instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public PodOS getOs();
  public io.fabric8.kubernetes.api.model.PodOS buildOs();
  public A withOs(io.fabric8.kubernetes.api.model.PodOS os);
  public java.lang.Boolean hasOs();
  public A withNewOs(java.lang.String name);
  public PodSpecFluent.OsNested<A> withNewOs();
  public io.fabric8.kubernetes.api.model.PodSpecFluent.OsNested<A> withNewOsLike(io.fabric8.kubernetes.api.model.PodOS item);
  public io.fabric8.kubernetes.api.model.PodSpecFluent.OsNested<A> editOs();
  public io.fabric8.kubernetes.api.model.PodSpecFluent.OsNested<A> editOrNewOs();
  public io.fabric8.kubernetes.api.model.PodSpecFluent.OsNested<A> editOrNewOsLike(io.fabric8.kubernetes.api.model.PodOS item);
  public A addToOverhead(java.lang.String key,Quantity value);
  public A addToOverhead(java.util.Map<java.lang.String,io.fabric8.kubernetes.api.model.Quantity> map);
  public A removeFromOverhead(java.lang.String key);
  public A removeFromOverhead(java.util.Map<java.lang.String,io.fabric8.kubernetes.api.model.Quantity> map);
  public java.util.Map<java.lang.String,io.fabric8.kubernetes.api.model.Quantity> getOverhead();
  public <K,V>A withOverhead(java.util.Map<java.lang.String,io.fabric8.kubernetes.api.model.Quantity> overhead);
  public java.lang.Boolean hasOverhead();
  public java.lang.String getPreemptionPolicy();
  public A withPreemptionPolicy(java.lang.String preemptionPolicy);
  public java.lang.Boolean hasPreemptionPolicy();
  public java.lang.Integer getPriority();
  public A withPriority(java.lang.Integer priority);
  public java.lang.Boolean hasPriority();
  public java.lang.String getPriorityClassName();
  public A withPriorityClassName(java.lang.String priorityClassName);
  public java.lang.Boolean hasPriorityClassName();
  public A addToReadinessGates(java.lang.Integer index,PodReadinessGate item);
  public A setToReadinessGates(java.lang.Integer index,io.fabric8.kubernetes.api.model.PodReadinessGate item);
  public A addToReadinessGates(io.fabric8.kubernetes.api.model.PodReadinessGate... items);
  public A addAllToReadinessGates(java.util.Collection<io.fabric8.kubernetes.api.model.PodReadinessGate> items);
  public A removeFromReadinessGates(io.fabric8.kubernetes.api.model.PodReadinessGate... items);
  public A removeAllFromReadinessGates(java.util.Collection<io.fabric8.kubernetes.api.model.PodReadinessGate> items);
  public A removeMatchingFromReadinessGates(java.util.function.Predicate<PodReadinessGateBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildReadinessGates instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public java.util.List<io.fabric8.kubernetes.api.model.PodReadinessGate> getReadinessGates();
  public java.util.List<io.fabric8.kubernetes.api.model.PodReadinessGate> buildReadinessGates();
  public io.fabric8.kubernetes.api.model.PodReadinessGate buildReadinessGate(java.lang.Integer index);
  public io.fabric8.kubernetes.api.model.PodReadinessGate buildFirstReadinessGate();
  public io.fabric8.kubernetes.api.model.PodReadinessGate buildLastReadinessGate();
  public io.fabric8.kubernetes.api.model.PodReadinessGate buildMatchingReadinessGate(java.util.function.Predicate<io.fabric8.kubernetes.api.model.PodReadinessGateBuilder> predicate);
  public java.lang.Boolean hasMatchingReadinessGate(java.util.function.Predicate<io.fabric8.kubernetes.api.model.PodReadinessGateBuilder> predicate);
  public A withReadinessGates(java.util.List<io.fabric8.kubernetes.api.model.PodReadinessGate> readinessGates);
  public A withReadinessGates(io.fabric8.kubernetes.api.model.PodReadinessGate... readinessGates);
  public java.lang.Boolean hasReadinessGates();
  public A addNewReadinessGate(java.lang.String conditionType);
  public PodSpecFluent.ReadinessGatesNested<A> addNewReadinessGate();
  public io.fabric8.kubernetes.api.model.PodSpecFluent.ReadinessGatesNested<A> addNewReadinessGateLike(io.fabric8.kubernetes.api.model.PodReadinessGate item);
  public io.fabric8.kubernetes.api.model.PodSpecFluent.ReadinessGatesNested<A> setNewReadinessGateLike(java.lang.Integer index,io.fabric8.kubernetes.api.model.PodReadinessGate item);
  public io.fabric8.kubernetes.api.model.PodSpecFluent.ReadinessGatesNested<A> editReadinessGate(java.lang.Integer index);
  public io.fabric8.kubernetes.api.model.PodSpecFluent.ReadinessGatesNested<A> editFirstReadinessGate();
  public io.fabric8.kubernetes.api.model.PodSpecFluent.ReadinessGatesNested<A> editLastReadinessGate();
  public io.fabric8.kubernetes.api.model.PodSpecFluent.ReadinessGatesNested<A> editMatchingReadinessGate(java.util.function.Predicate<io.fabric8.kubernetes.api.model.PodReadinessGateBuilder> predicate);
  public java.lang.String getRestartPolicy();
  public A withRestartPolicy(java.lang.String restartPolicy);
  public java.lang.Boolean hasRestartPolicy();
  public java.lang.String getRuntimeClassName();
  public A withRuntimeClassName(java.lang.String runtimeClassName);
  public java.lang.Boolean hasRuntimeClassName();
  public java.lang.String getSchedulerName();
  public A withSchedulerName(java.lang.String schedulerName);
  public java.lang.Boolean hasSchedulerName();
  
  /**
   * This method has been deprecated, please use method buildSecurityContext instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public PodSecurityContext getSecurityContext();
  public io.fabric8.kubernetes.api.model.PodSecurityContext buildSecurityContext();
  public A withSecurityContext(io.fabric8.kubernetes.api.model.PodSecurityContext securityContext);
  public java.lang.Boolean hasSecurityContext();
  public PodSpecFluent.SecurityContextNested<A> withNewSecurityContext();
  public io.fabric8.kubernetes.api.model.PodSpecFluent.SecurityContextNested<A> withNewSecurityContextLike(io.fabric8.kubernetes.api.model.PodSecurityContext item);
  public io.fabric8.kubernetes.api.model.PodSpecFluent.SecurityContextNested<A> editSecurityContext();
  public io.fabric8.kubernetes.api.model.PodSpecFluent.SecurityContextNested<A> editOrNewSecurityContext();
  public io.fabric8.kubernetes.api.model.PodSpecFluent.SecurityContextNested<A> editOrNewSecurityContextLike(io.fabric8.kubernetes.api.model.PodSecurityContext item);
  public java.lang.String getServiceAccount();
  public A withServiceAccount(java.lang.String serviceAccount);
  public java.lang.Boolean hasServiceAccount();
  public java.lang.String getServiceAccountName();
  public A withServiceAccountName(java.lang.String serviceAccountName);
  public java.lang.Boolean hasServiceAccountName();
  public java.lang.Boolean getSetHostnameAsFQDN();
  public A withSetHostnameAsFQDN(java.lang.Boolean setHostnameAsFQDN);
  public java.lang.Boolean hasSetHostnameAsFQDN();
  public java.lang.Boolean getShareProcessNamespace();
  public A withShareProcessNamespace(java.lang.Boolean shareProcessNamespace);
  public java.lang.Boolean hasShareProcessNamespace();
  public java.lang.String getSubdomain();
  public A withSubdomain(java.lang.String subdomain);
  public java.lang.Boolean hasSubdomain();
  public java.lang.Long getTerminationGracePeriodSeconds();
  public A withTerminationGracePeriodSeconds(java.lang.Long terminationGracePeriodSeconds);
  public java.lang.Boolean hasTerminationGracePeriodSeconds();
  public A addToTolerations(java.lang.Integer index,Toleration item);
  public A setToTolerations(java.lang.Integer index,io.fabric8.kubernetes.api.model.Toleration item);
  public A addToTolerations(io.fabric8.kubernetes.api.model.Toleration... items);
  public A addAllToTolerations(java.util.Collection<io.fabric8.kubernetes.api.model.Toleration> items);
  public A removeFromTolerations(io.fabric8.kubernetes.api.model.Toleration... items);
  public A removeAllFromTolerations(java.util.Collection<io.fabric8.kubernetes.api.model.Toleration> items);
  public A removeMatchingFromTolerations(java.util.function.Predicate<TolerationBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildTolerations instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public java.util.List<io.fabric8.kubernetes.api.model.Toleration> getTolerations();
  public java.util.List<io.fabric8.kubernetes.api.model.Toleration> buildTolerations();
  public io.fabric8.kubernetes.api.model.Toleration buildToleration(java.lang.Integer index);
  public io.fabric8.kubernetes.api.model.Toleration buildFirstToleration();
  public io.fabric8.kubernetes.api.model.Toleration buildLastToleration();
  public io.fabric8.kubernetes.api.model.Toleration buildMatchingToleration(java.util.function.Predicate<io.fabric8.kubernetes.api.model.TolerationBuilder> predicate);
  public java.lang.Boolean hasMatchingToleration(java.util.function.Predicate<io.fabric8.kubernetes.api.model.TolerationBuilder> predicate);
  public A withTolerations(java.util.List<io.fabric8.kubernetes.api.model.Toleration> tolerations);
  public A withTolerations(io.fabric8.kubernetes.api.model.Toleration... tolerations);
  public java.lang.Boolean hasTolerations();
  public A addNewToleration(java.lang.String effect,java.lang.String key,java.lang.String operator,java.lang.Long tolerationSeconds,java.lang.String value);
  public PodSpecFluent.TolerationsNested<A> addNewToleration();
  public io.fabric8.kubernetes.api.model.PodSpecFluent.TolerationsNested<A> addNewTolerationLike(io.fabric8.kubernetes.api.model.Toleration item);
  public io.fabric8.kubernetes.api.model.PodSpecFluent.TolerationsNested<A> setNewTolerationLike(java.lang.Integer index,io.fabric8.kubernetes.api.model.Toleration item);
  public io.fabric8.kubernetes.api.model.PodSpecFluent.TolerationsNested<A> editToleration(java.lang.Integer index);
  public io.fabric8.kubernetes.api.model.PodSpecFluent.TolerationsNested<A> editFirstToleration();
  public io.fabric8.kubernetes.api.model.PodSpecFluent.TolerationsNested<A> editLastToleration();
  public io.fabric8.kubernetes.api.model.PodSpecFluent.TolerationsNested<A> editMatchingToleration(java.util.function.Predicate<io.fabric8.kubernetes.api.model.TolerationBuilder> predicate);
  public A addToTopologySpreadConstraints(java.lang.Integer index,TopologySpreadConstraint item);
  public A setToTopologySpreadConstraints(java.lang.Integer index,io.fabric8.kubernetes.api.model.TopologySpreadConstraint item);
  public A addToTopologySpreadConstraints(io.fabric8.kubernetes.api.model.TopologySpreadConstraint... items);
  public A addAllToTopologySpreadConstraints(java.util.Collection<io.fabric8.kubernetes.api.model.TopologySpreadConstraint> items);
  public A removeFromTopologySpreadConstraints(io.fabric8.kubernetes.api.model.TopologySpreadConstraint... items);
  public A removeAllFromTopologySpreadConstraints(java.util.Collection<io.fabric8.kubernetes.api.model.TopologySpreadConstraint> items);
  public A removeMatchingFromTopologySpreadConstraints(java.util.function.Predicate<TopologySpreadConstraintBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildTopologySpreadConstraints instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public java.util.List<io.fabric8.kubernetes.api.model.TopologySpreadConstraint> getTopologySpreadConstraints();
  public java.util.List<io.fabric8.kubernetes.api.model.TopologySpreadConstraint> buildTopologySpreadConstraints();
  public io.fabric8.kubernetes.api.model.TopologySpreadConstraint buildTopologySpreadConstraint(java.lang.Integer index);
  public io.fabric8.kubernetes.api.model.TopologySpreadConstraint buildFirstTopologySpreadConstraint();
  public io.fabric8.kubernetes.api.model.TopologySpreadConstraint buildLastTopologySpreadConstraint();
  public io.fabric8.kubernetes.api.model.TopologySpreadConstraint buildMatchingTopologySpreadConstraint(java.util.function.Predicate<io.fabric8.kubernetes.api.model.TopologySpreadConstraintBuilder> predicate);
  public java.lang.Boolean hasMatchingTopologySpreadConstraint(java.util.function.Predicate<io.fabric8.kubernetes.api.model.TopologySpreadConstraintBuilder> predicate);
  public A withTopologySpreadConstraints(java.util.List<io.fabric8.kubernetes.api.model.TopologySpreadConstraint> topologySpreadConstraints);
  public A withTopologySpreadConstraints(io.fabric8.kubernetes.api.model.TopologySpreadConstraint... topologySpreadConstraints);
  public java.lang.Boolean hasTopologySpreadConstraints();
  public PodSpecFluent.TopologySpreadConstraintsNested<A> addNewTopologySpreadConstraint();
  public io.fabric8.kubernetes.api.model.PodSpecFluent.TopologySpreadConstraintsNested<A> addNewTopologySpreadConstraintLike(io.fabric8.kubernetes.api.model.TopologySpreadConstraint item);
  public io.fabric8.kubernetes.api.model.PodSpecFluent.TopologySpreadConstraintsNested<A> setNewTopologySpreadConstraintLike(java.lang.Integer index,io.fabric8.kubernetes.api.model.TopologySpreadConstraint item);
  public io.fabric8.kubernetes.api.model.PodSpecFluent.TopologySpreadConstraintsNested<A> editTopologySpreadConstraint(java.lang.Integer index);
  public io.fabric8.kubernetes.api.model.PodSpecFluent.TopologySpreadConstraintsNested<A> editFirstTopologySpreadConstraint();
  public io.fabric8.kubernetes.api.model.PodSpecFluent.TopologySpreadConstraintsNested<A> editLastTopologySpreadConstraint();
  public io.fabric8.kubernetes.api.model.PodSpecFluent.TopologySpreadConstraintsNested<A> editMatchingTopologySpreadConstraint(java.util.function.Predicate<io.fabric8.kubernetes.api.model.TopologySpreadConstraintBuilder> predicate);
  public A addToVolumes(java.lang.Integer index,Volume item);
  public A setToVolumes(java.lang.Integer index,io.fabric8.kubernetes.api.model.Volume item);
  public A addToVolumes(io.fabric8.kubernetes.api.model.Volume... items);
  public A addAllToVolumes(java.util.Collection<io.fabric8.kubernetes.api.model.Volume> items);
  public A removeFromVolumes(io.fabric8.kubernetes.api.model.Volume... items);
  public A removeAllFromVolumes(java.util.Collection<io.fabric8.kubernetes.api.model.Volume> items);
  public A removeMatchingFromVolumes(java.util.function.Predicate<VolumeBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildVolumes instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public java.util.List<io.fabric8.kubernetes.api.model.Volume> getVolumes();
  public java.util.List<io.fabric8.kubernetes.api.model.Volume> buildVolumes();
  public io.fabric8.kubernetes.api.model.Volume buildVolume(java.lang.Integer index);
  public io.fabric8.kubernetes.api.model.Volume buildFirstVolume();
  public io.fabric8.kubernetes.api.model.Volume buildLastVolume();
  public io.fabric8.kubernetes.api.model.Volume buildMatchingVolume(java.util.function.Predicate<io.fabric8.kubernetes.api.model.VolumeBuilder> predicate);
  public java.lang.Boolean hasMatchingVolume(java.util.function.Predicate<io.fabric8.kubernetes.api.model.VolumeBuilder> predicate);
  public A withVolumes(java.util.List<io.fabric8.kubernetes.api.model.Volume> volumes);
  public A withVolumes(io.fabric8.kubernetes.api.model.Volume... volumes);
  public java.lang.Boolean hasVolumes();
  public PodSpecFluent.VolumesNested<A> addNewVolume();
  public io.fabric8.kubernetes.api.model.PodSpecFluent.VolumesNested<A> addNewVolumeLike(io.fabric8.kubernetes.api.model.Volume item);
  public io.fabric8.kubernetes.api.model.PodSpecFluent.VolumesNested<A> setNewVolumeLike(java.lang.Integer index,io.fabric8.kubernetes.api.model.Volume item);
  public io.fabric8.kubernetes.api.model.PodSpecFluent.VolumesNested<A> editVolume(java.lang.Integer index);
  public io.fabric8.kubernetes.api.model.PodSpecFluent.VolumesNested<A> editFirstVolume();
  public io.fabric8.kubernetes.api.model.PodSpecFluent.VolumesNested<A> editLastVolume();
  public io.fabric8.kubernetes.api.model.PodSpecFluent.VolumesNested<A> editMatchingVolume(java.util.function.Predicate<io.fabric8.kubernetes.api.model.VolumeBuilder> predicate);
  public A addToAdditionalProperties(java.lang.String key,Object value);
  public A addToAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map);
  public A removeFromAdditionalProperties(java.lang.String key);
  public A removeFromAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map);
  public java.util.Map<java.lang.String,java.lang.Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> additionalProperties);
  public java.lang.Boolean hasAdditionalProperties();
  public A withAutomountServiceAccountToken();
  public A withEnableServiceLinks();
  public A withHostIPC();
  public A withHostNetwork();
  public A withHostPID();
  public A withSetHostnameAsFQDN();
  public A withShareProcessNamespace();
  public interface AffinityNested<N> extends Nested<N>,AffinityFluent<PodSpecFluent.AffinityNested<N>>{
    public N and();
    public N endAffinity();
    
  }
  public interface ContainersNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ContainerFluent<PodSpecFluent.ContainersNested<N>>{
    public N and();
    public N endContainer();
    
  }
  public interface DnsConfigNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,PodDNSConfigFluent<PodSpecFluent.DnsConfigNested<N>>{
    public N and();
    public N endDnsConfig();
    
  }
  public interface EphemeralContainersNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,EphemeralContainerFluent<PodSpecFluent.EphemeralContainersNested<N>>{
    public N and();
    public N endEphemeralContainer();
    
  }
  public interface HostAliasesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,HostAliasFluent<PodSpecFluent.HostAliasesNested<N>>{
    public N and();
    public N endHostAlias();
    
  }
  public interface ImagePullSecretsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,LocalObjectReferenceFluent<PodSpecFluent.ImagePullSecretsNested<N>>{
    public N and();
    public N endImagePullSecret();
    
  }
  public interface InitContainersNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ContainerFluent<PodSpecFluent.InitContainersNested<N>>{
    public N and();
    public N endInitContainer();
    
  }
  public interface OsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,PodOSFluent<PodSpecFluent.OsNested<N>>{
    public N and();
    public N endOs();
    
  }
  public interface ReadinessGatesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,PodReadinessGateFluent<PodSpecFluent.ReadinessGatesNested<N>>{
    public N and();
    public N endReadinessGate();
    
  }
  public interface SecurityContextNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,PodSecurityContextFluent<PodSpecFluent.SecurityContextNested<N>>{
    public N and();
    public N endSecurityContext();
    
  }
  public interface TolerationsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,TolerationFluent<PodSpecFluent.TolerationsNested<N>>{
    public N and();
    public N endToleration();
    
  }
  public interface TopologySpreadConstraintsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,TopologySpreadConstraintFluent<PodSpecFluent.TopologySpreadConstraintsNested<N>>{
    public N and();
    public N endTopologySpreadConstraint();
    
  }
  public interface VolumesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,VolumeFluent<PodSpecFluent.VolumesNested<N>>{
    public N and();
    public N endVolume();
    
  }
  
}