package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PodTemplateBuilder extends PodTemplateFluentImpl<PodTemplateBuilder> implements VisitableBuilder<PodTemplate,io.fabric8.kubernetes.api.model.PodTemplateBuilder>{
  public PodTemplateBuilder() {
    this(false);
  }
  public PodTemplateBuilder(Boolean validationEnabled) {
    this(new PodTemplate(), validationEnabled);
  }
  public PodTemplateBuilder(PodTemplateFluent<?> fluent) {
    this(fluent, false);
  }
  public PodTemplateBuilder(io.fabric8.kubernetes.api.model.PodTemplateFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new PodTemplate(), validationEnabled);
  }
  public PodTemplateBuilder(io.fabric8.kubernetes.api.model.PodTemplateFluent<?> fluent,io.fabric8.kubernetes.api.model.PodTemplate instance) {
    this(fluent, instance, false);
  }
  public PodTemplateBuilder(io.fabric8.kubernetes.api.model.PodTemplateFluent<?> fluent,io.fabric8.kubernetes.api.model.PodTemplate instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withTemplate(instance.getTemplate()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public PodTemplateBuilder(io.fabric8.kubernetes.api.model.PodTemplate instance) {
    this(instance,false);
  }
  public PodTemplateBuilder(io.fabric8.kubernetes.api.model.PodTemplate instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withTemplate(instance.getTemplate()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.PodTemplateFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.PodTemplate build() {
    PodTemplate buildable = new PodTemplate(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getTemplate());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}