package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PodTemplateListBuilder extends PodTemplateListFluentImpl<PodTemplateListBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.PodTemplateList,PodTemplateListBuilder>{
  public PodTemplateListBuilder() {
    this(false);
  }
  public PodTemplateListBuilder(Boolean validationEnabled) {
    this(new PodTemplateList(), validationEnabled);
  }
  public PodTemplateListBuilder(io.fabric8.kubernetes.api.model.PodTemplateListFluent<?> fluent) {
    this(fluent, false);
  }
  public PodTemplateListBuilder(io.fabric8.kubernetes.api.model.PodTemplateListFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new PodTemplateList(), validationEnabled);
  }
  public PodTemplateListBuilder(io.fabric8.kubernetes.api.model.PodTemplateListFluent<?> fluent,io.fabric8.kubernetes.api.model.PodTemplateList instance) {
    this(fluent, instance, false);
  }
  public PodTemplateListBuilder(io.fabric8.kubernetes.api.model.PodTemplateListFluent<?> fluent,io.fabric8.kubernetes.api.model.PodTemplateList instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public PodTemplateListBuilder(io.fabric8.kubernetes.api.model.PodTemplateList instance) {
    this(instance,false);
  }
  public PodTemplateListBuilder(io.fabric8.kubernetes.api.model.PodTemplateList instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.PodTemplateListFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.PodTemplateList build() {
    PodTemplateList buildable = new PodTemplateList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}