package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PodTemplateSpecBuilder extends PodTemplateSpecFluentImpl<PodTemplateSpecBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.PodTemplateSpec,io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder>{
  public PodTemplateSpecBuilder() {
    this(false);
  }
  public PodTemplateSpecBuilder(Boolean validationEnabled) {
    this(new PodTemplateSpec(), validationEnabled);
  }
  public PodTemplateSpecBuilder(PodTemplateSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public PodTemplateSpecBuilder(io.fabric8.kubernetes.api.model.PodTemplateSpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new PodTemplateSpec(), validationEnabled);
  }
  public PodTemplateSpecBuilder(io.fabric8.kubernetes.api.model.PodTemplateSpecFluent<?> fluent,io.fabric8.kubernetes.api.model.PodTemplateSpec instance) {
    this(fluent, instance, false);
  }
  public PodTemplateSpecBuilder(io.fabric8.kubernetes.api.model.PodTemplateSpecFluent<?> fluent,io.fabric8.kubernetes.api.model.PodTemplateSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public PodTemplateSpecBuilder(io.fabric8.kubernetes.api.model.PodTemplateSpec instance) {
    this(instance,false);
  }
  public PodTemplateSpecBuilder(io.fabric8.kubernetes.api.model.PodTemplateSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.PodTemplateSpecFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.PodTemplateSpec build() {
    PodTemplateSpec buildable = new PodTemplateSpec(fluent.getMetadata(),fluent.getSpec());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}