package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PortStatusBuilder extends PortStatusFluentImpl<PortStatusBuilder> implements VisitableBuilder<PortStatus,io.fabric8.kubernetes.api.model.PortStatusBuilder>{
  public PortStatusBuilder() {
    this(false);
  }
  public PortStatusBuilder(Boolean validationEnabled) {
    this(new PortStatus(), validationEnabled);
  }
  public PortStatusBuilder(io.fabric8.kubernetes.api.model.PortStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public PortStatusBuilder(io.fabric8.kubernetes.api.model.PortStatusFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new PortStatus(), validationEnabled);
  }
  public PortStatusBuilder(io.fabric8.kubernetes.api.model.PortStatusFluent<?> fluent,io.fabric8.kubernetes.api.model.PortStatus instance) {
    this(fluent, instance, false);
  }
  public PortStatusBuilder(io.fabric8.kubernetes.api.model.PortStatusFluent<?> fluent,io.fabric8.kubernetes.api.model.PortStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withError(instance.getError()); 
    fluent.withPort(instance.getPort()); 
    fluent.withProtocol(instance.getProtocol()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public PortStatusBuilder(io.fabric8.kubernetes.api.model.PortStatus instance) {
    this(instance,false);
  }
  public PortStatusBuilder(io.fabric8.kubernetes.api.model.PortStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withError(instance.getError()); 
    this.withPort(instance.getPort()); 
    this.withProtocol(instance.getProtocol()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.PortStatusFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.PortStatus build() {
    PortStatus buildable = new PortStatus(fluent.getError(),fluent.getPort(),fluent.getProtocol());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}