package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PortworxVolumeSourceBuilder extends PortworxVolumeSourceFluentImpl<PortworxVolumeSourceBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.PortworxVolumeSource,io.fabric8.kubernetes.api.model.PortworxVolumeSourceBuilder>{
  public PortworxVolumeSourceBuilder() {
    this(false);
  }
  public PortworxVolumeSourceBuilder(Boolean validationEnabled) {
    this(new PortworxVolumeSource(), validationEnabled);
  }
  public PortworxVolumeSourceBuilder(PortworxVolumeSourceFluent<?> fluent) {
    this(fluent, false);
  }
  public PortworxVolumeSourceBuilder(io.fabric8.kubernetes.api.model.PortworxVolumeSourceFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new PortworxVolumeSource(), validationEnabled);
  }
  public PortworxVolumeSourceBuilder(io.fabric8.kubernetes.api.model.PortworxVolumeSourceFluent<?> fluent,io.fabric8.kubernetes.api.model.PortworxVolumeSource instance) {
    this(fluent, instance, false);
  }
  public PortworxVolumeSourceBuilder(io.fabric8.kubernetes.api.model.PortworxVolumeSourceFluent<?> fluent,io.fabric8.kubernetes.api.model.PortworxVolumeSource instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withFsType(instance.getFsType()); 
    fluent.withReadOnly(instance.getReadOnly()); 
    fluent.withVolumeID(instance.getVolumeID()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public PortworxVolumeSourceBuilder(io.fabric8.kubernetes.api.model.PortworxVolumeSource instance) {
    this(instance,false);
  }
  public PortworxVolumeSourceBuilder(io.fabric8.kubernetes.api.model.PortworxVolumeSource instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withFsType(instance.getFsType()); 
    this.withReadOnly(instance.getReadOnly()); 
    this.withVolumeID(instance.getVolumeID()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.PortworxVolumeSourceFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.PortworxVolumeSource build() {
    PortworxVolumeSource buildable = new PortworxVolumeSource(fluent.getFsType(),fluent.getReadOnly(),fluent.getVolumeID());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}