package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PreconditionsBuilder extends PreconditionsFluentImpl<PreconditionsBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.Preconditions,PreconditionsBuilder>{
  public PreconditionsBuilder() {
    this(false);
  }
  public PreconditionsBuilder(Boolean validationEnabled) {
    this(new Preconditions(), validationEnabled);
  }
  public PreconditionsBuilder(io.fabric8.kubernetes.api.model.PreconditionsFluent<?> fluent) {
    this(fluent, false);
  }
  public PreconditionsBuilder(io.fabric8.kubernetes.api.model.PreconditionsFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new Preconditions(), validationEnabled);
  }
  public PreconditionsBuilder(io.fabric8.kubernetes.api.model.PreconditionsFluent<?> fluent,io.fabric8.kubernetes.api.model.Preconditions instance) {
    this(fluent, instance, false);
  }
  public PreconditionsBuilder(io.fabric8.kubernetes.api.model.PreconditionsFluent<?> fluent,io.fabric8.kubernetes.api.model.Preconditions instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withResourceVersion(instance.getResourceVersion()); 
    fluent.withUid(instance.getUid()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public PreconditionsBuilder(io.fabric8.kubernetes.api.model.Preconditions instance) {
    this(instance,false);
  }
  public PreconditionsBuilder(io.fabric8.kubernetes.api.model.Preconditions instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withResourceVersion(instance.getResourceVersion()); 
    this.withUid(instance.getUid()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.PreconditionsFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.Preconditions build() {
    Preconditions buildable = new Preconditions(fluent.getResourceVersion(),fluent.getUid());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}