package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PreferencesBuilder extends PreferencesFluentImpl<PreferencesBuilder> implements VisitableBuilder<Preferences,io.fabric8.kubernetes.api.model.PreferencesBuilder>{
  public PreferencesBuilder() {
    this(false);
  }
  public PreferencesBuilder(Boolean validationEnabled) {
    this(new Preferences(), validationEnabled);
  }
  public PreferencesBuilder(io.fabric8.kubernetes.api.model.PreferencesFluent<?> fluent) {
    this(fluent, false);
  }
  public PreferencesBuilder(io.fabric8.kubernetes.api.model.PreferencesFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new Preferences(), validationEnabled);
  }
  public PreferencesBuilder(io.fabric8.kubernetes.api.model.PreferencesFluent<?> fluent,io.fabric8.kubernetes.api.model.Preferences instance) {
    this(fluent, instance, false);
  }
  public PreferencesBuilder(io.fabric8.kubernetes.api.model.PreferencesFluent<?> fluent,io.fabric8.kubernetes.api.model.Preferences instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withColors(instance.getColors()); 
    fluent.withExtensions(instance.getExtensions()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public PreferencesBuilder(io.fabric8.kubernetes.api.model.Preferences instance) {
    this(instance,false);
  }
  public PreferencesBuilder(io.fabric8.kubernetes.api.model.Preferences instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withColors(instance.getColors()); 
    this.withExtensions(instance.getExtensions()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.PreferencesFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.Preferences build() {
    Preferences buildable = new Preferences(fluent.getColors(),fluent.getExtensions());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}