package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PreferredSchedulingTermBuilder extends PreferredSchedulingTermFluentImpl<PreferredSchedulingTermBuilder> implements VisitableBuilder<PreferredSchedulingTerm,io.fabric8.kubernetes.api.model.PreferredSchedulingTermBuilder>{
  public PreferredSchedulingTermBuilder() {
    this(false);
  }
  public PreferredSchedulingTermBuilder(Boolean validationEnabled) {
    this(new PreferredSchedulingTerm(), validationEnabled);
  }
  public PreferredSchedulingTermBuilder(io.fabric8.kubernetes.api.model.PreferredSchedulingTermFluent<?> fluent) {
    this(fluent, false);
  }
  public PreferredSchedulingTermBuilder(io.fabric8.kubernetes.api.model.PreferredSchedulingTermFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new PreferredSchedulingTerm(), validationEnabled);
  }
  public PreferredSchedulingTermBuilder(io.fabric8.kubernetes.api.model.PreferredSchedulingTermFluent<?> fluent,io.fabric8.kubernetes.api.model.PreferredSchedulingTerm instance) {
    this(fluent, instance, false);
  }
  public PreferredSchedulingTermBuilder(io.fabric8.kubernetes.api.model.PreferredSchedulingTermFluent<?> fluent,io.fabric8.kubernetes.api.model.PreferredSchedulingTerm instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withPreference(instance.getPreference()); 
    fluent.withWeight(instance.getWeight()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public PreferredSchedulingTermBuilder(io.fabric8.kubernetes.api.model.PreferredSchedulingTerm instance) {
    this(instance,false);
  }
  public PreferredSchedulingTermBuilder(io.fabric8.kubernetes.api.model.PreferredSchedulingTerm instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withPreference(instance.getPreference()); 
    this.withWeight(instance.getWeight()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.PreferredSchedulingTermFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.PreferredSchedulingTerm build() {
    PreferredSchedulingTerm buildable = new PreferredSchedulingTerm(fluent.getPreference(),fluent.getWeight());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}