package io.fabric8.kubernetes.api.model;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ProbeFluentImpl<A extends ProbeFluent<A>> extends BaseFluent<A> implements ProbeFluent<A>{
  public ProbeFluentImpl() {
  }
  public ProbeFluentImpl(io.fabric8.kubernetes.api.model.Probe instance) {
    this.withExec(instance.getExec()); 
    this.withFailureThreshold(instance.getFailureThreshold()); 
    this.withGrpc(instance.getGrpc()); 
    this.withHttpGet(instance.getHttpGet()); 
    this.withInitialDelaySeconds(instance.getInitialDelaySeconds()); 
    this.withPeriodSeconds(instance.getPeriodSeconds()); 
    this.withSuccessThreshold(instance.getSuccessThreshold()); 
    this.withTcpSocket(instance.getTcpSocket()); 
    this.withTerminationGracePeriodSeconds(instance.getTerminationGracePeriodSeconds()); 
    this.withTimeoutSeconds(instance.getTimeoutSeconds()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private ExecActionBuilder exec;
  private Integer failureThreshold;
  private GRPCActionBuilder grpc;
  private HTTPGetActionBuilder httpGet;
  private java.lang.Integer initialDelaySeconds;
  private java.lang.Integer periodSeconds;
  private java.lang.Integer successThreshold;
  private TCPSocketActionBuilder tcpSocket;
  private Long terminationGracePeriodSeconds;
  private java.lang.Integer timeoutSeconds;
  private Map<String,Object> additionalProperties;
  
  /**
   * This method has been deprecated, please use method buildExec instead.
   * @return The buildable object.
   */
  @Deprecated
  public io.fabric8.kubernetes.api.model.ExecAction getExec() {
    return this.exec!=null ?this.exec.build():null;
  }
  public io.fabric8.kubernetes.api.model.ExecAction buildExec() {
    return this.exec!=null ?this.exec.build():null;
  }
  public A withExec(io.fabric8.kubernetes.api.model.ExecAction exec) {
    _visitables.get("exec").remove(this.exec);
    if (exec!=null){ this.exec= new ExecActionBuilder(exec); _visitables.get("exec").add(this.exec);} return (A) this;
  }
  public Boolean hasExec() {
    return this.exec != null;
  }
  public ProbeFluent.ExecNested<A> withNewExec() {
    return new ProbeFluentImpl.ExecNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.ProbeFluent.ExecNested<A> withNewExecLike(io.fabric8.kubernetes.api.model.ExecAction item) {
    return new ProbeFluentImpl.ExecNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.ProbeFluent.ExecNested<A> editExec() {
    return withNewExecLike(getExec());
  }
  public io.fabric8.kubernetes.api.model.ProbeFluent.ExecNested<A> editOrNewExec() {
    return withNewExecLike(getExec() != null ? getExec(): new io.fabric8.kubernetes.api.model.ExecActionBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.ProbeFluent.ExecNested<A> editOrNewExecLike(io.fabric8.kubernetes.api.model.ExecAction item) {
    return withNewExecLike(getExec() != null ? getExec(): item);
  }
  public java.lang.Integer getFailureThreshold() {
    return this.failureThreshold;
  }
  public A withFailureThreshold(java.lang.Integer failureThreshold) {
    this.failureThreshold=failureThreshold; return (A) this;
  }
  public java.lang.Boolean hasFailureThreshold() {
    return this.failureThreshold != null;
  }
  
  /**
   * This method has been deprecated, please use method buildGrpc instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.GRPCAction getGrpc() {
    return this.grpc!=null ?this.grpc.build():null;
  }
  public io.fabric8.kubernetes.api.model.GRPCAction buildGrpc() {
    return this.grpc!=null ?this.grpc.build():null;
  }
  public A withGrpc(io.fabric8.kubernetes.api.model.GRPCAction grpc) {
    _visitables.get("grpc").remove(this.grpc);
    if (grpc!=null){ this.grpc= new GRPCActionBuilder(grpc); _visitables.get("grpc").add(this.grpc);} return (A) this;
  }
  public java.lang.Boolean hasGrpc() {
    return this.grpc != null;
  }
  public A withNewGrpc(java.lang.Integer port,java.lang.String service) {
    return (A)withGrpc(new GRPCAction(port, service));
  }
  public ProbeFluent.GrpcNested<A> withNewGrpc() {
    return new ProbeFluentImpl.GrpcNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.ProbeFluent.GrpcNested<A> withNewGrpcLike(io.fabric8.kubernetes.api.model.GRPCAction item) {
    return new io.fabric8.kubernetes.api.model.ProbeFluentImpl.GrpcNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.ProbeFluent.GrpcNested<A> editGrpc() {
    return withNewGrpcLike(getGrpc());
  }
  public io.fabric8.kubernetes.api.model.ProbeFluent.GrpcNested<A> editOrNewGrpc() {
    return withNewGrpcLike(getGrpc() != null ? getGrpc(): new io.fabric8.kubernetes.api.model.GRPCActionBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.ProbeFluent.GrpcNested<A> editOrNewGrpcLike(io.fabric8.kubernetes.api.model.GRPCAction item) {
    return withNewGrpcLike(getGrpc() != null ? getGrpc(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildHttpGet instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.HTTPGetAction getHttpGet() {
    return this.httpGet!=null ?this.httpGet.build():null;
  }
  public io.fabric8.kubernetes.api.model.HTTPGetAction buildHttpGet() {
    return this.httpGet!=null ?this.httpGet.build():null;
  }
  public A withHttpGet(io.fabric8.kubernetes.api.model.HTTPGetAction httpGet) {
    _visitables.get("httpGet").remove(this.httpGet);
    if (httpGet!=null){ this.httpGet= new HTTPGetActionBuilder(httpGet); _visitables.get("httpGet").add(this.httpGet);} return (A) this;
  }
  public java.lang.Boolean hasHttpGet() {
    return this.httpGet != null;
  }
  public ProbeFluent.HttpGetNested<A> withNewHttpGet() {
    return new ProbeFluentImpl.HttpGetNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.ProbeFluent.HttpGetNested<A> withNewHttpGetLike(io.fabric8.kubernetes.api.model.HTTPGetAction item) {
    return new io.fabric8.kubernetes.api.model.ProbeFluentImpl.HttpGetNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.ProbeFluent.HttpGetNested<A> editHttpGet() {
    return withNewHttpGetLike(getHttpGet());
  }
  public io.fabric8.kubernetes.api.model.ProbeFluent.HttpGetNested<A> editOrNewHttpGet() {
    return withNewHttpGetLike(getHttpGet() != null ? getHttpGet(): new io.fabric8.kubernetes.api.model.HTTPGetActionBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.ProbeFluent.HttpGetNested<A> editOrNewHttpGetLike(io.fabric8.kubernetes.api.model.HTTPGetAction item) {
    return withNewHttpGetLike(getHttpGet() != null ? getHttpGet(): item);
  }
  public java.lang.Integer getInitialDelaySeconds() {
    return this.initialDelaySeconds;
  }
  public A withInitialDelaySeconds(java.lang.Integer initialDelaySeconds) {
    this.initialDelaySeconds=initialDelaySeconds; return (A) this;
  }
  public java.lang.Boolean hasInitialDelaySeconds() {
    return this.initialDelaySeconds != null;
  }
  public java.lang.Integer getPeriodSeconds() {
    return this.periodSeconds;
  }
  public A withPeriodSeconds(java.lang.Integer periodSeconds) {
    this.periodSeconds=periodSeconds; return (A) this;
  }
  public java.lang.Boolean hasPeriodSeconds() {
    return this.periodSeconds != null;
  }
  public java.lang.Integer getSuccessThreshold() {
    return this.successThreshold;
  }
  public A withSuccessThreshold(java.lang.Integer successThreshold) {
    this.successThreshold=successThreshold; return (A) this;
  }
  public java.lang.Boolean hasSuccessThreshold() {
    return this.successThreshold != null;
  }
  
  /**
   * This method has been deprecated, please use method buildTcpSocket instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public TCPSocketAction getTcpSocket() {
    return this.tcpSocket!=null ?this.tcpSocket.build():null;
  }
  public io.fabric8.kubernetes.api.model.TCPSocketAction buildTcpSocket() {
    return this.tcpSocket!=null ?this.tcpSocket.build():null;
  }
  public A withTcpSocket(io.fabric8.kubernetes.api.model.TCPSocketAction tcpSocket) {
    _visitables.get("tcpSocket").remove(this.tcpSocket);
    if (tcpSocket!=null){ this.tcpSocket= new io.fabric8.kubernetes.api.model.TCPSocketActionBuilder(tcpSocket); _visitables.get("tcpSocket").add(this.tcpSocket);} return (A) this;
  }
  public java.lang.Boolean hasTcpSocket() {
    return this.tcpSocket != null;
  }
  public ProbeFluent.TcpSocketNested<A> withNewTcpSocket() {
    return new ProbeFluentImpl.TcpSocketNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.ProbeFluent.TcpSocketNested<A> withNewTcpSocketLike(io.fabric8.kubernetes.api.model.TCPSocketAction item) {
    return new io.fabric8.kubernetes.api.model.ProbeFluentImpl.TcpSocketNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.ProbeFluent.TcpSocketNested<A> editTcpSocket() {
    return withNewTcpSocketLike(getTcpSocket());
  }
  public io.fabric8.kubernetes.api.model.ProbeFluent.TcpSocketNested<A> editOrNewTcpSocket() {
    return withNewTcpSocketLike(getTcpSocket() != null ? getTcpSocket(): new io.fabric8.kubernetes.api.model.TCPSocketActionBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.ProbeFluent.TcpSocketNested<A> editOrNewTcpSocketLike(io.fabric8.kubernetes.api.model.TCPSocketAction item) {
    return withNewTcpSocketLike(getTcpSocket() != null ? getTcpSocket(): item);
  }
  public java.lang.Long getTerminationGracePeriodSeconds() {
    return this.terminationGracePeriodSeconds;
  }
  public A withTerminationGracePeriodSeconds(java.lang.Long terminationGracePeriodSeconds) {
    this.terminationGracePeriodSeconds=terminationGracePeriodSeconds; return (A) this;
  }
  public java.lang.Boolean hasTerminationGracePeriodSeconds() {
    return this.terminationGracePeriodSeconds != null;
  }
  public java.lang.Integer getTimeoutSeconds() {
    return this.timeoutSeconds;
  }
  public A withTimeoutSeconds(java.lang.Integer timeoutSeconds) {
    this.timeoutSeconds=timeoutSeconds; return (A) this;
  }
  public java.lang.Boolean hasTimeoutSeconds() {
    return this.timeoutSeconds != null;
  }
  public A addToAdditionalProperties(java.lang.String key,java.lang.Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new java.util.LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.lang.String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new java.util.LinkedHashMap(additionalProperties);} return (A) this;
  }
  public java.lang.Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ProbeFluentImpl that = (ProbeFluentImpl) o;
    if (exec != null ? !exec.equals(that.exec) :that.exec != null) return false;
    if (failureThreshold != null ? !failureThreshold.equals(that.failureThreshold) :that.failureThreshold != null) return false;
    if (grpc != null ? !grpc.equals(that.grpc) :that.grpc != null) return false;
    if (httpGet != null ? !httpGet.equals(that.httpGet) :that.httpGet != null) return false;
    if (initialDelaySeconds != null ? !initialDelaySeconds.equals(that.initialDelaySeconds) :that.initialDelaySeconds != null) return false;
    if (periodSeconds != null ? !periodSeconds.equals(that.periodSeconds) :that.periodSeconds != null) return false;
    if (successThreshold != null ? !successThreshold.equals(that.successThreshold) :that.successThreshold != null) return false;
    if (tcpSocket != null ? !tcpSocket.equals(that.tcpSocket) :that.tcpSocket != null) return false;
    if (terminationGracePeriodSeconds != null ? !terminationGracePeriodSeconds.equals(that.terminationGracePeriodSeconds) :that.terminationGracePeriodSeconds != null) return false;
    if (timeoutSeconds != null ? !timeoutSeconds.equals(that.timeoutSeconds) :that.timeoutSeconds != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(exec,  failureThreshold,  grpc,  httpGet,  initialDelaySeconds,  periodSeconds,  successThreshold,  tcpSocket,  terminationGracePeriodSeconds,  timeoutSeconds,  additionalProperties,  super.hashCode());
  }
  public java.lang.String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (exec != null) { sb.append("exec:"); sb.append(exec + ","); }
    if (failureThreshold != null) { sb.append("failureThreshold:"); sb.append(failureThreshold + ","); }
    if (grpc != null) { sb.append("grpc:"); sb.append(grpc + ","); }
    if (httpGet != null) { sb.append("httpGet:"); sb.append(httpGet + ","); }
    if (initialDelaySeconds != null) { sb.append("initialDelaySeconds:"); sb.append(initialDelaySeconds + ","); }
    if (periodSeconds != null) { sb.append("periodSeconds:"); sb.append(periodSeconds + ","); }
    if (successThreshold != null) { sb.append("successThreshold:"); sb.append(successThreshold + ","); }
    if (tcpSocket != null) { sb.append("tcpSocket:"); sb.append(tcpSocket + ","); }
    if (terminationGracePeriodSeconds != null) { sb.append("terminationGracePeriodSeconds:"); sb.append(terminationGracePeriodSeconds + ","); }
    if (timeoutSeconds != null) { sb.append("timeoutSeconds:"); sb.append(timeoutSeconds + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class ExecNestedImpl<N> extends ExecActionFluentImpl<ProbeFluent.ExecNested<N>> implements io.fabric8.kubernetes.api.model.ProbeFluent.ExecNested<N>,Nested<N>{
    ExecNestedImpl(io.fabric8.kubernetes.api.model.ExecAction item) {
      this.builder = new ExecActionBuilder(this, item);
    }
    ExecNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.ExecActionBuilder(this);
    }
    io.fabric8.kubernetes.api.model.ExecActionBuilder builder;
    public N and() {
      return (N) ProbeFluentImpl.this.withExec(builder.build());
    }
    public N endExec() {
      return and();
    }
    
  }
  class GrpcNestedImpl<N> extends GRPCActionFluentImpl<ProbeFluent.GrpcNested<N>> implements io.fabric8.kubernetes.api.model.ProbeFluent.GrpcNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    GrpcNestedImpl(io.fabric8.kubernetes.api.model.GRPCAction item) {
      this.builder = new GRPCActionBuilder(this, item);
    }
    GrpcNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.GRPCActionBuilder(this);
    }
    io.fabric8.kubernetes.api.model.GRPCActionBuilder builder;
    public N and() {
      return (N) ProbeFluentImpl.this.withGrpc(builder.build());
    }
    public N endGrpc() {
      return and();
    }
    
  }
  class HttpGetNestedImpl<N> extends HTTPGetActionFluentImpl<ProbeFluent.HttpGetNested<N>> implements io.fabric8.kubernetes.api.model.ProbeFluent.HttpGetNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    HttpGetNestedImpl(HTTPGetAction item) {
      this.builder = new HTTPGetActionBuilder(this, item);
    }
    HttpGetNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.HTTPGetActionBuilder(this);
    }
    io.fabric8.kubernetes.api.model.HTTPGetActionBuilder builder;
    public N and() {
      return (N) ProbeFluentImpl.this.withHttpGet(builder.build());
    }
    public N endHttpGet() {
      return and();
    }
    
  }
  class TcpSocketNestedImpl<N> extends TCPSocketActionFluentImpl<ProbeFluent.TcpSocketNested<N>> implements io.fabric8.kubernetes.api.model.ProbeFluent.TcpSocketNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    TcpSocketNestedImpl(io.fabric8.kubernetes.api.model.TCPSocketAction item) {
      this.builder = new TCPSocketActionBuilder(this, item);
    }
    TcpSocketNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.TCPSocketActionBuilder(this);
    }
    io.fabric8.kubernetes.api.model.TCPSocketActionBuilder builder;
    public N and() {
      return (N) ProbeFluentImpl.this.withTcpSocket(builder.build());
    }
    public N endTcpSocket() {
      return and();
    }
    
  }
  
}