package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;

 /**
  * Quantity is fixed point representation of a number.
  * It provides convenient marshalling/unmarshalling in JSON or YAML,
  * in addition to String or getAmountInBytes accessors.
  */
public class QuantityBuilder extends QuantityFluentImpl<QuantityBuilder> implements VisitableBuilder<Quantity,io.fabric8.kubernetes.api.model.QuantityBuilder>{
  public QuantityBuilder() {
    this(false);
  }
  public QuantityBuilder(Boolean validationEnabled) {
    this(new Quantity(), validationEnabled);
  }
  public QuantityBuilder(io.fabric8.kubernetes.api.model.QuantityFluent<?> fluent) {
    this(fluent, false);
  }
  public QuantityBuilder(io.fabric8.kubernetes.api.model.QuantityFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new Quantity(), validationEnabled);
  }
  public QuantityBuilder(io.fabric8.kubernetes.api.model.QuantityFluent<?> fluent,io.fabric8.kubernetes.api.model.Quantity instance) {
    this(fluent, instance, false);
  }
  public QuantityBuilder(io.fabric8.kubernetes.api.model.QuantityFluent<?> fluent,io.fabric8.kubernetes.api.model.Quantity instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAmount(instance.getAmount()); 
    fluent.withFormat(instance.getFormat());

    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public QuantityBuilder(io.fabric8.kubernetes.api.model.Quantity instance) {
    this(instance,false);
  }
  public QuantityBuilder(io.fabric8.kubernetes.api.model.Quantity instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withAmount(instance.getAmount()); 
    this.withFormat(instance.getFormat());

    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.QuantityFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.Quantity build() {
    Quantity buildable = new Quantity(fluent.getAmount());
    buildable.setFormat(fluent.getFormat());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}