package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class RBDPersistentVolumeSourceBuilder extends RBDPersistentVolumeSourceFluentImpl<RBDPersistentVolumeSourceBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.RBDPersistentVolumeSource,RBDPersistentVolumeSourceBuilder>{
  public RBDPersistentVolumeSourceBuilder() {
    this(false);
  }
  public RBDPersistentVolumeSourceBuilder(Boolean validationEnabled) {
    this(new RBDPersistentVolumeSource(), validationEnabled);
  }
  public RBDPersistentVolumeSourceBuilder(io.fabric8.kubernetes.api.model.RBDPersistentVolumeSourceFluent<?> fluent) {
    this(fluent, false);
  }
  public RBDPersistentVolumeSourceBuilder(io.fabric8.kubernetes.api.model.RBDPersistentVolumeSourceFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new RBDPersistentVolumeSource(), validationEnabled);
  }
  public RBDPersistentVolumeSourceBuilder(io.fabric8.kubernetes.api.model.RBDPersistentVolumeSourceFluent<?> fluent,io.fabric8.kubernetes.api.model.RBDPersistentVolumeSource instance) {
    this(fluent, instance, false);
  }
  public RBDPersistentVolumeSourceBuilder(io.fabric8.kubernetes.api.model.RBDPersistentVolumeSourceFluent<?> fluent,io.fabric8.kubernetes.api.model.RBDPersistentVolumeSource instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withFsType(instance.getFsType()); 
    fluent.withImage(instance.getImage()); 
    fluent.withKeyring(instance.getKeyring()); 
    fluent.withMonitors(instance.getMonitors()); 
    fluent.withPool(instance.getPool()); 
    fluent.withReadOnly(instance.getReadOnly()); 
    fluent.withSecretRef(instance.getSecretRef()); 
    fluent.withUser(instance.getUser()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public RBDPersistentVolumeSourceBuilder(io.fabric8.kubernetes.api.model.RBDPersistentVolumeSource instance) {
    this(instance,false);
  }
  public RBDPersistentVolumeSourceBuilder(io.fabric8.kubernetes.api.model.RBDPersistentVolumeSource instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withFsType(instance.getFsType()); 
    this.withImage(instance.getImage()); 
    this.withKeyring(instance.getKeyring()); 
    this.withMonitors(instance.getMonitors()); 
    this.withPool(instance.getPool()); 
    this.withReadOnly(instance.getReadOnly()); 
    this.withSecretRef(instance.getSecretRef()); 
    this.withUser(instance.getUser()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.RBDPersistentVolumeSourceFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.RBDPersistentVolumeSource build() {
    RBDPersistentVolumeSource buildable = new RBDPersistentVolumeSource(fluent.getFsType(),fluent.getImage(),fluent.getKeyring(),fluent.getMonitors(),fluent.getPool(),fluent.getReadOnly(),fluent.getSecretRef(),fluent.getUser());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}