package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class RBDVolumeSourceBuilder extends RBDVolumeSourceFluentImpl<RBDVolumeSourceBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.RBDVolumeSource,io.fabric8.kubernetes.api.model.RBDVolumeSourceBuilder>{
  public RBDVolumeSourceBuilder() {
    this(false);
  }
  public RBDVolumeSourceBuilder(Boolean validationEnabled) {
    this(new RBDVolumeSource(), validationEnabled);
  }
  public RBDVolumeSourceBuilder(RBDVolumeSourceFluent<?> fluent) {
    this(fluent, false);
  }
  public RBDVolumeSourceBuilder(io.fabric8.kubernetes.api.model.RBDVolumeSourceFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new RBDVolumeSource(), validationEnabled);
  }
  public RBDVolumeSourceBuilder(io.fabric8.kubernetes.api.model.RBDVolumeSourceFluent<?> fluent,io.fabric8.kubernetes.api.model.RBDVolumeSource instance) {
    this(fluent, instance, false);
  }
  public RBDVolumeSourceBuilder(io.fabric8.kubernetes.api.model.RBDVolumeSourceFluent<?> fluent,io.fabric8.kubernetes.api.model.RBDVolumeSource instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withFsType(instance.getFsType()); 
    fluent.withImage(instance.getImage()); 
    fluent.withKeyring(instance.getKeyring()); 
    fluent.withMonitors(instance.getMonitors()); 
    fluent.withPool(instance.getPool()); 
    fluent.withReadOnly(instance.getReadOnly()); 
    fluent.withSecretRef(instance.getSecretRef()); 
    fluent.withUser(instance.getUser()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public RBDVolumeSourceBuilder(io.fabric8.kubernetes.api.model.RBDVolumeSource instance) {
    this(instance,false);
  }
  public RBDVolumeSourceBuilder(io.fabric8.kubernetes.api.model.RBDVolumeSource instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withFsType(instance.getFsType()); 
    this.withImage(instance.getImage()); 
    this.withKeyring(instance.getKeyring()); 
    this.withMonitors(instance.getMonitors()); 
    this.withPool(instance.getPool()); 
    this.withReadOnly(instance.getReadOnly()); 
    this.withSecretRef(instance.getSecretRef()); 
    this.withUser(instance.getUser()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.RBDVolumeSourceFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.RBDVolumeSource build() {
    RBDVolumeSource buildable = new RBDVolumeSource(fluent.getFsType(),fluent.getImage(),fluent.getKeyring(),fluent.getMonitors(),fluent.getPool(),fluent.getReadOnly(),fluent.getSecretRef(),fluent.getUser());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}