package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ReplicationControllerBuilder extends ReplicationControllerFluentImpl<ReplicationControllerBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.ReplicationController,io.fabric8.kubernetes.api.model.ReplicationControllerBuilder>{
  public ReplicationControllerBuilder() {
    this(false);
  }
  public ReplicationControllerBuilder(Boolean validationEnabled) {
    this(new ReplicationController(), validationEnabled);
  }
  public ReplicationControllerBuilder(ReplicationControllerFluent<?> fluent) {
    this(fluent, false);
  }
  public ReplicationControllerBuilder(io.fabric8.kubernetes.api.model.ReplicationControllerFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ReplicationController(), validationEnabled);
  }
  public ReplicationControllerBuilder(io.fabric8.kubernetes.api.model.ReplicationControllerFluent<?> fluent,io.fabric8.kubernetes.api.model.ReplicationController instance) {
    this(fluent, instance, false);
  }
  public ReplicationControllerBuilder(io.fabric8.kubernetes.api.model.ReplicationControllerFluent<?> fluent,io.fabric8.kubernetes.api.model.ReplicationController instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withStatus(instance.getStatus()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ReplicationControllerBuilder(io.fabric8.kubernetes.api.model.ReplicationController instance) {
    this(instance,false);
  }
  public ReplicationControllerBuilder(io.fabric8.kubernetes.api.model.ReplicationController instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.ReplicationControllerFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.ReplicationController build() {
    ReplicationController buildable = new ReplicationController(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}