package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ReplicationControllerConditionBuilder extends ReplicationControllerConditionFluentImpl<ReplicationControllerConditionBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.ReplicationControllerCondition,io.fabric8.kubernetes.api.model.ReplicationControllerConditionBuilder>{
  public ReplicationControllerConditionBuilder() {
    this(false);
  }
  public ReplicationControllerConditionBuilder(Boolean validationEnabled) {
    this(new ReplicationControllerCondition(), validationEnabled);
  }
  public ReplicationControllerConditionBuilder(ReplicationControllerConditionFluent<?> fluent) {
    this(fluent, false);
  }
  public ReplicationControllerConditionBuilder(io.fabric8.kubernetes.api.model.ReplicationControllerConditionFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ReplicationControllerCondition(), validationEnabled);
  }
  public ReplicationControllerConditionBuilder(io.fabric8.kubernetes.api.model.ReplicationControllerConditionFluent<?> fluent,io.fabric8.kubernetes.api.model.ReplicationControllerCondition instance) {
    this(fluent, instance, false);
  }
  public ReplicationControllerConditionBuilder(io.fabric8.kubernetes.api.model.ReplicationControllerConditionFluent<?> fluent,io.fabric8.kubernetes.api.model.ReplicationControllerCondition instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withLastTransitionTime(instance.getLastTransitionTime()); 
    fluent.withMessage(instance.getMessage()); 
    fluent.withReason(instance.getReason()); 
    fluent.withStatus(instance.getStatus()); 
    fluent.withType(instance.getType()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ReplicationControllerConditionBuilder(io.fabric8.kubernetes.api.model.ReplicationControllerCondition instance) {
    this(instance,false);
  }
  public ReplicationControllerConditionBuilder(io.fabric8.kubernetes.api.model.ReplicationControllerCondition instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withLastTransitionTime(instance.getLastTransitionTime()); 
    this.withMessage(instance.getMessage()); 
    this.withReason(instance.getReason()); 
    this.withStatus(instance.getStatus()); 
    this.withType(instance.getType()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.ReplicationControllerConditionFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.ReplicationControllerCondition build() {
    ReplicationControllerCondition buildable = new ReplicationControllerCondition(fluent.getLastTransitionTime(),fluent.getMessage(),fluent.getReason(),fluent.getStatus(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}