package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ReplicationControllerListBuilder extends ReplicationControllerListFluentImpl<ReplicationControllerListBuilder> implements VisitableBuilder<ReplicationControllerList,io.fabric8.kubernetes.api.model.ReplicationControllerListBuilder>{
  public ReplicationControllerListBuilder() {
    this(false);
  }
  public ReplicationControllerListBuilder(Boolean validationEnabled) {
    this(new ReplicationControllerList(), validationEnabled);
  }
  public ReplicationControllerListBuilder(io.fabric8.kubernetes.api.model.ReplicationControllerListFluent<?> fluent) {
    this(fluent, false);
  }
  public ReplicationControllerListBuilder(io.fabric8.kubernetes.api.model.ReplicationControllerListFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ReplicationControllerList(), validationEnabled);
  }
  public ReplicationControllerListBuilder(io.fabric8.kubernetes.api.model.ReplicationControllerListFluent<?> fluent,io.fabric8.kubernetes.api.model.ReplicationControllerList instance) {
    this(fluent, instance, false);
  }
  public ReplicationControllerListBuilder(io.fabric8.kubernetes.api.model.ReplicationControllerListFluent<?> fluent,io.fabric8.kubernetes.api.model.ReplicationControllerList instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ReplicationControllerListBuilder(io.fabric8.kubernetes.api.model.ReplicationControllerList instance) {
    this(instance,false);
  }
  public ReplicationControllerListBuilder(io.fabric8.kubernetes.api.model.ReplicationControllerList instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.ReplicationControllerListFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.ReplicationControllerList build() {
    ReplicationControllerList buildable = new ReplicationControllerList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}