package io.fabric8.kubernetes.api.model;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ReplicationControllerSpecFluentImpl<A extends ReplicationControllerSpecFluent<A>> extends BaseFluent<A> implements ReplicationControllerSpecFluent<A>{
  public ReplicationControllerSpecFluentImpl() {
  }
  public ReplicationControllerSpecFluentImpl(io.fabric8.kubernetes.api.model.ReplicationControllerSpec instance) {
    this.withMinReadySeconds(instance.getMinReadySeconds()); 
    this.withReplicas(instance.getReplicas()); 
    this.withSelector(instance.getSelector()); 
    this.withTemplate(instance.getTemplate()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private Integer minReadySeconds;
  private java.lang.Integer replicas;
  private Map<String,java.lang.String> selector;
  private PodTemplateSpecBuilder template;
  private java.util.Map<java.lang.String,Object> additionalProperties;
  public java.lang.Integer getMinReadySeconds() {
    return this.minReadySeconds;
  }
  public A withMinReadySeconds(java.lang.Integer minReadySeconds) {
    this.minReadySeconds=minReadySeconds; return (A) this;
  }
  public Boolean hasMinReadySeconds() {
    return this.minReadySeconds != null;
  }
  public java.lang.Integer getReplicas() {
    return this.replicas;
  }
  public A withReplicas(java.lang.Integer replicas) {
    this.replicas=replicas; return (A) this;
  }
  public java.lang.Boolean hasReplicas() {
    return this.replicas != null;
  }
  public A addToSelector(java.lang.String key,java.lang.String value) {
    if(this.selector == null && key != null && value != null) { this.selector = new LinkedHashMap(); }
    if(key != null && value != null) {this.selector.put(key, value);} return (A)this;
  }
  public A addToSelector(java.util.Map<java.lang.String,java.lang.String> map) {
    if(this.selector == null && map != null) { this.selector = new java.util.LinkedHashMap(); }
    if(map != null) { this.selector.putAll(map);} return (A)this;
  }
  public A removeFromSelector(java.lang.String key) {
    if(this.selector == null) { return (A) this; }
    if(key != null && this.selector != null) {this.selector.remove(key);} return (A)this;
  }
  public A removeFromSelector(java.util.Map<java.lang.String,java.lang.String> map) {
    if(this.selector == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.selector != null){this.selector.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.String> getSelector() {
    return this.selector;
  }
  public <K,V>A withSelector(java.util.Map<java.lang.String,java.lang.String> selector) {
    if (selector == null) { this.selector =  null;} else {this.selector = new java.util.LinkedHashMap(selector);} return (A) this;
  }
  public java.lang.Boolean hasSelector() {
    return this.selector != null;
  }
  
  /**
   * This method has been deprecated, please use method buildTemplate instead.
   * @return The buildable object.
   */
  @Deprecated
  public io.fabric8.kubernetes.api.model.PodTemplateSpec getTemplate() {
    return this.template!=null ?this.template.build():null;
  }
  public io.fabric8.kubernetes.api.model.PodTemplateSpec buildTemplate() {
    return this.template!=null ?this.template.build():null;
  }
  public A withTemplate(io.fabric8.kubernetes.api.model.PodTemplateSpec template) {
    _visitables.get("template").remove(this.template);
    if (template!=null){ this.template= new PodTemplateSpecBuilder(template); _visitables.get("template").add(this.template);} return (A) this;
  }
  public java.lang.Boolean hasTemplate() {
    return this.template != null;
  }
  public ReplicationControllerSpecFluent.TemplateNested<A> withNewTemplate() {
    return new ReplicationControllerSpecFluentImpl.TemplateNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.ReplicationControllerSpecFluent.TemplateNested<A> withNewTemplateLike(io.fabric8.kubernetes.api.model.PodTemplateSpec item) {
    return new ReplicationControllerSpecFluentImpl.TemplateNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.ReplicationControllerSpecFluent.TemplateNested<A> editTemplate() {
    return withNewTemplateLike(getTemplate());
  }
  public io.fabric8.kubernetes.api.model.ReplicationControllerSpecFluent.TemplateNested<A> editOrNewTemplate() {
    return withNewTemplateLike(getTemplate() != null ? getTemplate(): new io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.ReplicationControllerSpecFluent.TemplateNested<A> editOrNewTemplateLike(io.fabric8.kubernetes.api.model.PodTemplateSpec item) {
    return withNewTemplateLike(getTemplate() != null ? getTemplate(): item);
  }
  public A addToAdditionalProperties(java.lang.String key,java.lang.Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new java.util.LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new java.util.LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.lang.String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new java.util.LinkedHashMap(additionalProperties);} return (A) this;
  }
  public java.lang.Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ReplicationControllerSpecFluentImpl that = (ReplicationControllerSpecFluentImpl) o;
    if (minReadySeconds != null ? !minReadySeconds.equals(that.minReadySeconds) :that.minReadySeconds != null) return false;
    if (replicas != null ? !replicas.equals(that.replicas) :that.replicas != null) return false;
    if (selector != null ? !selector.equals(that.selector) :that.selector != null) return false;
    if (template != null ? !template.equals(that.template) :that.template != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(minReadySeconds,  replicas,  selector,  template,  additionalProperties,  super.hashCode());
  }
  public java.lang.String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (minReadySeconds != null) { sb.append("minReadySeconds:"); sb.append(minReadySeconds + ","); }
    if (replicas != null) { sb.append("replicas:"); sb.append(replicas + ","); }
    if (selector != null && !selector.isEmpty()) { sb.append("selector:"); sb.append(selector + ","); }
    if (template != null) { sb.append("template:"); sb.append(template + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class TemplateNestedImpl<N> extends PodTemplateSpecFluentImpl<ReplicationControllerSpecFluent.TemplateNested<N>> implements io.fabric8.kubernetes.api.model.ReplicationControllerSpecFluent.TemplateNested<N>,Nested<N>{
    TemplateNestedImpl(io.fabric8.kubernetes.api.model.PodTemplateSpec item) {
      this.builder = new PodTemplateSpecBuilder(this, item);
    }
    TemplateNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder(this);
    }
    io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder builder;
    public N and() {
      return (N) ReplicationControllerSpecFluentImpl.this.withTemplate(builder.build());
    }
    public N endTemplate() {
      return and();
    }
    
  }
  
}