package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ReplicationControllerStatusFluentImpl<A extends ReplicationControllerStatusFluent<A>> extends BaseFluent<A> implements ReplicationControllerStatusFluent<A>{
  public ReplicationControllerStatusFluentImpl() {
  }
  public ReplicationControllerStatusFluentImpl(io.fabric8.kubernetes.api.model.ReplicationControllerStatus instance) {
    this.withAvailableReplicas(instance.getAvailableReplicas()); 
    this.withConditions(instance.getConditions()); 
    this.withFullyLabeledReplicas(instance.getFullyLabeledReplicas()); 
    this.withObservedGeneration(instance.getObservedGeneration()); 
    this.withReadyReplicas(instance.getReadyReplicas()); 
    this.withReplicas(instance.getReplicas()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private Integer availableReplicas;
  private ArrayList<ReplicationControllerConditionBuilder> conditions = new java.util.ArrayList<ReplicationControllerConditionBuilder>();
  private java.lang.Integer fullyLabeledReplicas;
  private Long observedGeneration;
  private java.lang.Integer readyReplicas;
  private java.lang.Integer replicas;
  private Map<String,Object> additionalProperties;
  public java.lang.Integer getAvailableReplicas() {
    return this.availableReplicas;
  }
  public A withAvailableReplicas(java.lang.Integer availableReplicas) {
    this.availableReplicas=availableReplicas; return (A) this;
  }
  public Boolean hasAvailableReplicas() {
    return this.availableReplicas != null;
  }
  public A addToConditions(java.lang.Integer index,io.fabric8.kubernetes.api.model.ReplicationControllerCondition item) {
    if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.kubernetes.api.model.ReplicationControllerConditionBuilder>();}
    io.fabric8.kubernetes.api.model.ReplicationControllerConditionBuilder builder = new io.fabric8.kubernetes.api.model.ReplicationControllerConditionBuilder(item);_visitables.get("conditions").add(index >= 0 ? index : _visitables.get("conditions").size(), builder);this.conditions.add(index >= 0 ? index : conditions.size(), builder); return (A)this;
  }
  public A setToConditions(java.lang.Integer index,io.fabric8.kubernetes.api.model.ReplicationControllerCondition item) {
    if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.kubernetes.api.model.ReplicationControllerConditionBuilder>();}
    io.fabric8.kubernetes.api.model.ReplicationControllerConditionBuilder builder = new io.fabric8.kubernetes.api.model.ReplicationControllerConditionBuilder(item);
    if (index < 0 || index >= _visitables.get("conditions").size()) { _visitables.get("conditions").add(builder); } else { _visitables.get("conditions").set(index, builder);}
    if (index < 0 || index >= conditions.size()) { conditions.add(builder); } else { conditions.set(index, builder);}
     return (A)this;
  }
  public A addToConditions(io.fabric8.kubernetes.api.model.ReplicationControllerCondition... items) {
    if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.kubernetes.api.model.ReplicationControllerConditionBuilder>();}
    for (io.fabric8.kubernetes.api.model.ReplicationControllerCondition item : items) {io.fabric8.kubernetes.api.model.ReplicationControllerConditionBuilder builder = new io.fabric8.kubernetes.api.model.ReplicationControllerConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A addAllToConditions(Collection<io.fabric8.kubernetes.api.model.ReplicationControllerCondition> items) {
    if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.kubernetes.api.model.ReplicationControllerConditionBuilder>();}
    for (io.fabric8.kubernetes.api.model.ReplicationControllerCondition item : items) {io.fabric8.kubernetes.api.model.ReplicationControllerConditionBuilder builder = new io.fabric8.kubernetes.api.model.ReplicationControllerConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A removeFromConditions(io.fabric8.kubernetes.api.model.ReplicationControllerCondition... items) {
    for (io.fabric8.kubernetes.api.model.ReplicationControllerCondition item : items) {io.fabric8.kubernetes.api.model.ReplicationControllerConditionBuilder builder = new io.fabric8.kubernetes.api.model.ReplicationControllerConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeAllFromConditions(java.util.Collection<io.fabric8.kubernetes.api.model.ReplicationControllerCondition> items) {
    for (io.fabric8.kubernetes.api.model.ReplicationControllerCondition item : items) {io.fabric8.kubernetes.api.model.ReplicationControllerConditionBuilder builder = new io.fabric8.kubernetes.api.model.ReplicationControllerConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromConditions(Predicate<io.fabric8.kubernetes.api.model.ReplicationControllerConditionBuilder> predicate) {
    if (conditions == null) return (A) this;
    final Iterator<io.fabric8.kubernetes.api.model.ReplicationControllerConditionBuilder> each = conditions.iterator();
    final List visitables = _visitables.get("conditions");
    while (each.hasNext()) {
      io.fabric8.kubernetes.api.model.ReplicationControllerConditionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildConditions instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<io.fabric8.kubernetes.api.model.ReplicationControllerCondition> getConditions() {
    return conditions != null ? build(conditions) : null;
  }
  public java.util.List<io.fabric8.kubernetes.api.model.ReplicationControllerCondition> buildConditions() {
    return conditions != null ? build(conditions) : null;
  }
  public io.fabric8.kubernetes.api.model.ReplicationControllerCondition buildCondition(java.lang.Integer index) {
    return this.conditions.get(index).build();
  }
  public io.fabric8.kubernetes.api.model.ReplicationControllerCondition buildFirstCondition() {
    return this.conditions.get(0).build();
  }
  public io.fabric8.kubernetes.api.model.ReplicationControllerCondition buildLastCondition() {
    return this.conditions.get(conditions.size() - 1).build();
  }
  public io.fabric8.kubernetes.api.model.ReplicationControllerCondition buildMatchingCondition(java.util.function.Predicate<io.fabric8.kubernetes.api.model.ReplicationControllerConditionBuilder> predicate) {
    for (io.fabric8.kubernetes.api.model.ReplicationControllerConditionBuilder item: conditions) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingCondition(java.util.function.Predicate<io.fabric8.kubernetes.api.model.ReplicationControllerConditionBuilder> predicate) {
    for (io.fabric8.kubernetes.api.model.ReplicationControllerConditionBuilder item: conditions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withConditions(java.util.List<io.fabric8.kubernetes.api.model.ReplicationControllerCondition> conditions) {
    if (this.conditions != null) { _visitables.get("conditions").removeAll(this.conditions);}
    if (conditions != null) {this.conditions = new java.util.ArrayList(); for (io.fabric8.kubernetes.api.model.ReplicationControllerCondition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
  }
  public A withConditions(io.fabric8.kubernetes.api.model.ReplicationControllerCondition... conditions) {
    if (this.conditions != null) {this.conditions.clear();}
    if (conditions != null) {for (io.fabric8.kubernetes.api.model.ReplicationControllerCondition item :conditions){ this.addToConditions(item);}} return (A) this;
  }
  public java.lang.Boolean hasConditions() {
    return conditions != null && !conditions.isEmpty();
  }
  public A addNewCondition(java.lang.String lastTransitionTime,java.lang.String message,java.lang.String reason,java.lang.String status,java.lang.String type) {
    return (A)addToConditions(new ReplicationControllerCondition(lastTransitionTime, message, reason, status, type));
  }
  public ReplicationControllerStatusFluent.ConditionsNested<A> addNewCondition() {
    return new ReplicationControllerStatusFluentImpl.ConditionsNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.ReplicationControllerStatusFluent.ConditionsNested<A> addNewConditionLike(io.fabric8.kubernetes.api.model.ReplicationControllerCondition item) {
    return new ReplicationControllerStatusFluentImpl.ConditionsNestedImpl(-1, item);
  }
  public io.fabric8.kubernetes.api.model.ReplicationControllerStatusFluent.ConditionsNested<A> setNewConditionLike(java.lang.Integer index,io.fabric8.kubernetes.api.model.ReplicationControllerCondition item) {
    return new io.fabric8.kubernetes.api.model.ReplicationControllerStatusFluentImpl.ConditionsNestedImpl(index, item);
  }
  public io.fabric8.kubernetes.api.model.ReplicationControllerStatusFluent.ConditionsNested<A> editCondition(java.lang.Integer index) {
    if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public io.fabric8.kubernetes.api.model.ReplicationControllerStatusFluent.ConditionsNested<A> editFirstCondition() {
    if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
    return setNewConditionLike(0, buildCondition(0));
  }
  public io.fabric8.kubernetes.api.model.ReplicationControllerStatusFluent.ConditionsNested<A> editLastCondition() {
    int index = conditions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public io.fabric8.kubernetes.api.model.ReplicationControllerStatusFluent.ConditionsNested<A> editMatchingCondition(java.util.function.Predicate<io.fabric8.kubernetes.api.model.ReplicationControllerConditionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<conditions.size();i++) { 
    if (predicate.test(conditions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public java.lang.Integer getFullyLabeledReplicas() {
    return this.fullyLabeledReplicas;
  }
  public A withFullyLabeledReplicas(java.lang.Integer fullyLabeledReplicas) {
    this.fullyLabeledReplicas=fullyLabeledReplicas; return (A) this;
  }
  public java.lang.Boolean hasFullyLabeledReplicas() {
    return this.fullyLabeledReplicas != null;
  }
  public java.lang.Long getObservedGeneration() {
    return this.observedGeneration;
  }
  public A withObservedGeneration(java.lang.Long observedGeneration) {
    this.observedGeneration=observedGeneration; return (A) this;
  }
  public java.lang.Boolean hasObservedGeneration() {
    return this.observedGeneration != null;
  }
  public java.lang.Integer getReadyReplicas() {
    return this.readyReplicas;
  }
  public A withReadyReplicas(java.lang.Integer readyReplicas) {
    this.readyReplicas=readyReplicas; return (A) this;
  }
  public java.lang.Boolean hasReadyReplicas() {
    return this.readyReplicas != null;
  }
  public java.lang.Integer getReplicas() {
    return this.replicas;
  }
  public A withReplicas(java.lang.Integer replicas) {
    this.replicas=replicas; return (A) this;
  }
  public java.lang.Boolean hasReplicas() {
    return this.replicas != null;
  }
  public A addToAdditionalProperties(java.lang.String key,java.lang.Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new java.util.LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.lang.String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new java.util.LinkedHashMap(additionalProperties);} return (A) this;
  }
  public java.lang.Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ReplicationControllerStatusFluentImpl that = (ReplicationControllerStatusFluentImpl) o;
    if (availableReplicas != null ? !availableReplicas.equals(that.availableReplicas) :that.availableReplicas != null) return false;
    if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
    if (fullyLabeledReplicas != null ? !fullyLabeledReplicas.equals(that.fullyLabeledReplicas) :that.fullyLabeledReplicas != null) return false;
    if (observedGeneration != null ? !observedGeneration.equals(that.observedGeneration) :that.observedGeneration != null) return false;
    if (readyReplicas != null ? !readyReplicas.equals(that.readyReplicas) :that.readyReplicas != null) return false;
    if (replicas != null ? !replicas.equals(that.replicas) :that.replicas != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(availableReplicas,  conditions,  fullyLabeledReplicas,  observedGeneration,  readyReplicas,  replicas,  additionalProperties,  super.hashCode());
  }
  public java.lang.String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (availableReplicas != null) { sb.append("availableReplicas:"); sb.append(availableReplicas + ","); }
    if (conditions != null && !conditions.isEmpty()) { sb.append("conditions:"); sb.append(conditions + ","); }
    if (fullyLabeledReplicas != null) { sb.append("fullyLabeledReplicas:"); sb.append(fullyLabeledReplicas + ","); }
    if (observedGeneration != null) { sb.append("observedGeneration:"); sb.append(observedGeneration + ","); }
    if (readyReplicas != null) { sb.append("readyReplicas:"); sb.append(readyReplicas + ","); }
    if (replicas != null) { sb.append("replicas:"); sb.append(replicas + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class ConditionsNestedImpl<N> extends ReplicationControllerConditionFluentImpl<ReplicationControllerStatusFluent.ConditionsNested<N>> implements io.fabric8.kubernetes.api.model.ReplicationControllerStatusFluent.ConditionsNested<N>,Nested<N>{
    ConditionsNestedImpl(java.lang.Integer index,io.fabric8.kubernetes.api.model.ReplicationControllerCondition item) {
      this.index = index;
      this.builder = new ReplicationControllerConditionBuilder(this, item);
    }
    ConditionsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.kubernetes.api.model.ReplicationControllerConditionBuilder(this);
    }
    io.fabric8.kubernetes.api.model.ReplicationControllerConditionBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) ReplicationControllerStatusFluentImpl.this.setToConditions(index,builder.build());
    }
    public N endCondition() {
      return and();
    }
    
  }
  
}