package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ResourceFieldSelectorBuilder extends ResourceFieldSelectorFluentImpl<ResourceFieldSelectorBuilder> implements VisitableBuilder<ResourceFieldSelector,io.fabric8.kubernetes.api.model.ResourceFieldSelectorBuilder>{
  public ResourceFieldSelectorBuilder() {
    this(false);
  }
  public ResourceFieldSelectorBuilder(Boolean validationEnabled) {
    this(new ResourceFieldSelector(), validationEnabled);
  }
  public ResourceFieldSelectorBuilder(ResourceFieldSelectorFluent<?> fluent) {
    this(fluent, false);
  }
  public ResourceFieldSelectorBuilder(io.fabric8.kubernetes.api.model.ResourceFieldSelectorFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ResourceFieldSelector(), validationEnabled);
  }
  public ResourceFieldSelectorBuilder(io.fabric8.kubernetes.api.model.ResourceFieldSelectorFluent<?> fluent,io.fabric8.kubernetes.api.model.ResourceFieldSelector instance) {
    this(fluent, instance, false);
  }
  public ResourceFieldSelectorBuilder(io.fabric8.kubernetes.api.model.ResourceFieldSelectorFluent<?> fluent,io.fabric8.kubernetes.api.model.ResourceFieldSelector instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withContainerName(instance.getContainerName()); 
    fluent.withDivisor(instance.getDivisor()); 
    fluent.withResource(instance.getResource()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ResourceFieldSelectorBuilder(io.fabric8.kubernetes.api.model.ResourceFieldSelector instance) {
    this(instance,false);
  }
  public ResourceFieldSelectorBuilder(io.fabric8.kubernetes.api.model.ResourceFieldSelector instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withContainerName(instance.getContainerName()); 
    this.withDivisor(instance.getDivisor()); 
    this.withResource(instance.getResource()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.ResourceFieldSelectorFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.ResourceFieldSelector build() {
    ResourceFieldSelector buildable = new ResourceFieldSelector(fluent.getContainerName(),fluent.getDivisor(),fluent.getResource());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}