package io.fabric8.kubernetes.api.model;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ResourceFieldSelectorFluentImpl<A extends ResourceFieldSelectorFluent<A>> extends BaseFluent<A> implements ResourceFieldSelectorFluent<A>{
  public ResourceFieldSelectorFluentImpl() {
  }
  public ResourceFieldSelectorFluentImpl(io.fabric8.kubernetes.api.model.ResourceFieldSelector instance) {
    this.withContainerName(instance.getContainerName()); 
    this.withDivisor(instance.getDivisor()); 
    this.withResource(instance.getResource()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private String containerName;
  private QuantityBuilder divisor;
  private java.lang.String resource;
  private Map<java.lang.String,Object> additionalProperties;
  public java.lang.String getContainerName() {
    return this.containerName;
  }
  public A withContainerName(java.lang.String containerName) {
    this.containerName=containerName; return (A) this;
  }
  public Boolean hasContainerName() {
    return this.containerName != null;
  }
  
  /**
   * This method has been deprecated, please use method buildDivisor instead.
   * @return The buildable object.
   */
  @Deprecated
  public Quantity getDivisor() {
    return this.divisor!=null ?this.divisor.build():null;
  }
  public io.fabric8.kubernetes.api.model.Quantity buildDivisor() {
    return this.divisor!=null ?this.divisor.build():null;
  }
  public A withDivisor(io.fabric8.kubernetes.api.model.Quantity divisor) {
    _visitables.get("divisor").remove(this.divisor);
    if (divisor!=null){ this.divisor= new io.fabric8.kubernetes.api.model.QuantityBuilder(divisor); _visitables.get("divisor").add(this.divisor);} return (A) this;
  }
  public java.lang.Boolean hasDivisor() {
    return this.divisor != null;
  }
  public A withNewDivisor(java.lang.String amount,java.lang.String format) {
    return (A)withDivisor(new Quantity(amount, format));
  }
  public A withNewDivisor(java.lang.String amount) {
    return (A)withDivisor(new Quantity(amount));
  }
  public ResourceFieldSelectorFluent.DivisorNested<A> withNewDivisor() {
    return new ResourceFieldSelectorFluentImpl.DivisorNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.ResourceFieldSelectorFluent.DivisorNested<A> withNewDivisorLike(io.fabric8.kubernetes.api.model.Quantity item) {
    return new ResourceFieldSelectorFluentImpl.DivisorNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.ResourceFieldSelectorFluent.DivisorNested<A> editDivisor() {
    return withNewDivisorLike(getDivisor());
  }
  public io.fabric8.kubernetes.api.model.ResourceFieldSelectorFluent.DivisorNested<A> editOrNewDivisor() {
    return withNewDivisorLike(getDivisor() != null ? getDivisor(): new io.fabric8.kubernetes.api.model.QuantityBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.ResourceFieldSelectorFluent.DivisorNested<A> editOrNewDivisorLike(io.fabric8.kubernetes.api.model.Quantity item) {
    return withNewDivisorLike(getDivisor() != null ? getDivisor(): item);
  }
  public java.lang.String getResource() {
    return this.resource;
  }
  public A withResource(java.lang.String resource) {
    this.resource=resource; return (A) this;
  }
  public java.lang.Boolean hasResource() {
    return this.resource != null;
  }
  public A addToAdditionalProperties(java.lang.String key,java.lang.Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new java.util.LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.lang.String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new java.util.LinkedHashMap(additionalProperties);} return (A) this;
  }
  public java.lang.Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ResourceFieldSelectorFluentImpl that = (ResourceFieldSelectorFluentImpl) o;
    if (containerName != null ? !containerName.equals(that.containerName) :that.containerName != null) return false;
    if (divisor != null ? !divisor.equals(that.divisor) :that.divisor != null) return false;
    if (resource != null ? !resource.equals(that.resource) :that.resource != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(containerName,  divisor,  resource,  additionalProperties,  super.hashCode());
  }
  public java.lang.String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (containerName != null) { sb.append("containerName:"); sb.append(containerName + ","); }
    if (divisor != null) { sb.append("divisor:"); sb.append(divisor + ","); }
    if (resource != null) { sb.append("resource:"); sb.append(resource + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class DivisorNestedImpl<N> extends QuantityFluentImpl<ResourceFieldSelectorFluent.DivisorNested<N>> implements io.fabric8.kubernetes.api.model.ResourceFieldSelectorFluent.DivisorNested<N>,Nested<N>{
    DivisorNestedImpl(io.fabric8.kubernetes.api.model.Quantity item) {
      this.builder = new QuantityBuilder(this, item);
    }
    DivisorNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.QuantityBuilder(this);
    }
    io.fabric8.kubernetes.api.model.QuantityBuilder builder;
    public N and() {
      return (N) ResourceFieldSelectorFluentImpl.this.withDivisor(builder.build());
    }
    public N endDivisor() {
      return and();
    }
    
  }
  
}