package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ResourceQuotaListBuilder extends ResourceQuotaListFluentImpl<ResourceQuotaListBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.ResourceQuotaList,io.fabric8.kubernetes.api.model.ResourceQuotaListBuilder>{
  public ResourceQuotaListBuilder() {
    this(false);
  }
  public ResourceQuotaListBuilder(Boolean validationEnabled) {
    this(new ResourceQuotaList(), validationEnabled);
  }
  public ResourceQuotaListBuilder(ResourceQuotaListFluent<?> fluent) {
    this(fluent, false);
  }
  public ResourceQuotaListBuilder(io.fabric8.kubernetes.api.model.ResourceQuotaListFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ResourceQuotaList(), validationEnabled);
  }
  public ResourceQuotaListBuilder(io.fabric8.kubernetes.api.model.ResourceQuotaListFluent<?> fluent,io.fabric8.kubernetes.api.model.ResourceQuotaList instance) {
    this(fluent, instance, false);
  }
  public ResourceQuotaListBuilder(io.fabric8.kubernetes.api.model.ResourceQuotaListFluent<?> fluent,io.fabric8.kubernetes.api.model.ResourceQuotaList instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ResourceQuotaListBuilder(io.fabric8.kubernetes.api.model.ResourceQuotaList instance) {
    this(instance,false);
  }
  public ResourceQuotaListBuilder(io.fabric8.kubernetes.api.model.ResourceQuotaList instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.ResourceQuotaListFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.ResourceQuotaList build() {
    ResourceQuotaList buildable = new ResourceQuotaList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}