package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ResourceQuotaStatusBuilder extends ResourceQuotaStatusFluentImpl<ResourceQuotaStatusBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.ResourceQuotaStatus,ResourceQuotaStatusBuilder>{
  public ResourceQuotaStatusBuilder() {
    this(false);
  }
  public ResourceQuotaStatusBuilder(Boolean validationEnabled) {
    this(new ResourceQuotaStatus(), validationEnabled);
  }
  public ResourceQuotaStatusBuilder(io.fabric8.kubernetes.api.model.ResourceQuotaStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public ResourceQuotaStatusBuilder(io.fabric8.kubernetes.api.model.ResourceQuotaStatusFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ResourceQuotaStatus(), validationEnabled);
  }
  public ResourceQuotaStatusBuilder(io.fabric8.kubernetes.api.model.ResourceQuotaStatusFluent<?> fluent,io.fabric8.kubernetes.api.model.ResourceQuotaStatus instance) {
    this(fluent, instance, false);
  }
  public ResourceQuotaStatusBuilder(io.fabric8.kubernetes.api.model.ResourceQuotaStatusFluent<?> fluent,io.fabric8.kubernetes.api.model.ResourceQuotaStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withHard(instance.getHard()); 
    fluent.withUsed(instance.getUsed()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ResourceQuotaStatusBuilder(io.fabric8.kubernetes.api.model.ResourceQuotaStatus instance) {
    this(instance,false);
  }
  public ResourceQuotaStatusBuilder(io.fabric8.kubernetes.api.model.ResourceQuotaStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withHard(instance.getHard()); 
    this.withUsed(instance.getUsed()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.ResourceQuotaStatusFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.ResourceQuotaStatus build() {
    ResourceQuotaStatus buildable = new ResourceQuotaStatus(fluent.getHard(),fluent.getUsed());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}