package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ResourceRequirementsBuilder extends ResourceRequirementsFluentImpl<ResourceRequirementsBuilder> implements VisitableBuilder<ResourceRequirements,io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder>{
  public ResourceRequirementsBuilder() {
    this(false);
  }
  public ResourceRequirementsBuilder(Boolean validationEnabled) {
    this(new ResourceRequirements(), validationEnabled);
  }
  public ResourceRequirementsBuilder(io.fabric8.kubernetes.api.model.ResourceRequirementsFluent<?> fluent) {
    this(fluent, false);
  }
  public ResourceRequirementsBuilder(io.fabric8.kubernetes.api.model.ResourceRequirementsFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ResourceRequirements(), validationEnabled);
  }
  public ResourceRequirementsBuilder(io.fabric8.kubernetes.api.model.ResourceRequirementsFluent<?> fluent,io.fabric8.kubernetes.api.model.ResourceRequirements instance) {
    this(fluent, instance, false);
  }
  public ResourceRequirementsBuilder(io.fabric8.kubernetes.api.model.ResourceRequirementsFluent<?> fluent,io.fabric8.kubernetes.api.model.ResourceRequirements instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withLimits(instance.getLimits()); 
    fluent.withRequests(instance.getRequests()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ResourceRequirementsBuilder(io.fabric8.kubernetes.api.model.ResourceRequirements instance) {
    this(instance,false);
  }
  public ResourceRequirementsBuilder(io.fabric8.kubernetes.api.model.ResourceRequirements instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withLimits(instance.getLimits()); 
    this.withRequests(instance.getRequests()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.ResourceRequirementsFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.ResourceRequirements build() {
    ResourceRequirements buildable = new ResourceRequirements(fluent.getLimits(),fluent.getRequests());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}