package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class RootPathsBuilder extends RootPathsFluentImpl<RootPathsBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.RootPaths,io.fabric8.kubernetes.api.model.RootPathsBuilder>{
  public RootPathsBuilder() {
    this(false);
  }
  public RootPathsBuilder(Boolean validationEnabled) {
    this(new RootPaths(), validationEnabled);
  }
  public RootPathsBuilder(RootPathsFluent<?> fluent) {
    this(fluent, false);
  }
  public RootPathsBuilder(io.fabric8.kubernetes.api.model.RootPathsFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new RootPaths(), validationEnabled);
  }
  public RootPathsBuilder(io.fabric8.kubernetes.api.model.RootPathsFluent<?> fluent,io.fabric8.kubernetes.api.model.RootPaths instance) {
    this(fluent, instance, false);
  }
  public RootPathsBuilder(io.fabric8.kubernetes.api.model.RootPathsFluent<?> fluent,io.fabric8.kubernetes.api.model.RootPaths instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withPaths(instance.getPaths()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public RootPathsBuilder(io.fabric8.kubernetes.api.model.RootPaths instance) {
    this(instance,false);
  }
  public RootPathsBuilder(io.fabric8.kubernetes.api.model.RootPaths instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withPaths(instance.getPaths()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.RootPathsFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.RootPaths build() {
    RootPaths buildable = new RootPaths(fluent.getPaths());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}