package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SELinuxOptionsBuilder extends SELinuxOptionsFluentImpl<SELinuxOptionsBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.SELinuxOptions,SELinuxOptionsBuilder>{
  public SELinuxOptionsBuilder() {
    this(false);
  }
  public SELinuxOptionsBuilder(Boolean validationEnabled) {
    this(new SELinuxOptions(), validationEnabled);
  }
  public SELinuxOptionsBuilder(io.fabric8.kubernetes.api.model.SELinuxOptionsFluent<?> fluent) {
    this(fluent, false);
  }
  public SELinuxOptionsBuilder(io.fabric8.kubernetes.api.model.SELinuxOptionsFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new SELinuxOptions(), validationEnabled);
  }
  public SELinuxOptionsBuilder(io.fabric8.kubernetes.api.model.SELinuxOptionsFluent<?> fluent,io.fabric8.kubernetes.api.model.SELinuxOptions instance) {
    this(fluent, instance, false);
  }
  public SELinuxOptionsBuilder(io.fabric8.kubernetes.api.model.SELinuxOptionsFluent<?> fluent,io.fabric8.kubernetes.api.model.SELinuxOptions instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withLevel(instance.getLevel()); 
    fluent.withRole(instance.getRole()); 
    fluent.withType(instance.getType()); 
    fluent.withUser(instance.getUser()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public SELinuxOptionsBuilder(io.fabric8.kubernetes.api.model.SELinuxOptions instance) {
    this(instance,false);
  }
  public SELinuxOptionsBuilder(io.fabric8.kubernetes.api.model.SELinuxOptions instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withLevel(instance.getLevel()); 
    this.withRole(instance.getRole()); 
    this.withType(instance.getType()); 
    this.withUser(instance.getUser()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.SELinuxOptionsFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.SELinuxOptions build() {
    SELinuxOptions buildable = new SELinuxOptions(fluent.getLevel(),fluent.getRole(),fluent.getType(),fluent.getUser());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}