package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ScaleIOVolumeSourceBuilder extends ScaleIOVolumeSourceFluentImpl<ScaleIOVolumeSourceBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.ScaleIOVolumeSource,io.fabric8.kubernetes.api.model.ScaleIOVolumeSourceBuilder>{
  public ScaleIOVolumeSourceBuilder() {
    this(false);
  }
  public ScaleIOVolumeSourceBuilder(Boolean validationEnabled) {
    this(new ScaleIOVolumeSource(), validationEnabled);
  }
  public ScaleIOVolumeSourceBuilder(ScaleIOVolumeSourceFluent<?> fluent) {
    this(fluent, false);
  }
  public ScaleIOVolumeSourceBuilder(io.fabric8.kubernetes.api.model.ScaleIOVolumeSourceFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ScaleIOVolumeSource(), validationEnabled);
  }
  public ScaleIOVolumeSourceBuilder(io.fabric8.kubernetes.api.model.ScaleIOVolumeSourceFluent<?> fluent,io.fabric8.kubernetes.api.model.ScaleIOVolumeSource instance) {
    this(fluent, instance, false);
  }
  public ScaleIOVolumeSourceBuilder(io.fabric8.kubernetes.api.model.ScaleIOVolumeSourceFluent<?> fluent,io.fabric8.kubernetes.api.model.ScaleIOVolumeSource instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withFsType(instance.getFsType()); 
    fluent.withGateway(instance.getGateway()); 
    fluent.withProtectionDomain(instance.getProtectionDomain()); 
    fluent.withReadOnly(instance.getReadOnly()); 
    fluent.withSecretRef(instance.getSecretRef()); 
    fluent.withSslEnabled(instance.getSslEnabled()); 
    fluent.withStorageMode(instance.getStorageMode()); 
    fluent.withStoragePool(instance.getStoragePool()); 
    fluent.withSystem(instance.getSystem()); 
    fluent.withVolumeName(instance.getVolumeName()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ScaleIOVolumeSourceBuilder(io.fabric8.kubernetes.api.model.ScaleIOVolumeSource instance) {
    this(instance,false);
  }
  public ScaleIOVolumeSourceBuilder(io.fabric8.kubernetes.api.model.ScaleIOVolumeSource instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withFsType(instance.getFsType()); 
    this.withGateway(instance.getGateway()); 
    this.withProtectionDomain(instance.getProtectionDomain()); 
    this.withReadOnly(instance.getReadOnly()); 
    this.withSecretRef(instance.getSecretRef()); 
    this.withSslEnabled(instance.getSslEnabled()); 
    this.withStorageMode(instance.getStorageMode()); 
    this.withStoragePool(instance.getStoragePool()); 
    this.withSystem(instance.getSystem()); 
    this.withVolumeName(instance.getVolumeName()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.ScaleIOVolumeSourceFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.ScaleIOVolumeSource build() {
    ScaleIOVolumeSource buildable = new ScaleIOVolumeSource(fluent.getFsType(),fluent.getGateway(),fluent.getProtectionDomain(),fluent.getReadOnly(),fluent.getSecretRef(),fluent.getSslEnabled(),fluent.getStorageMode(),fluent.getStoragePool(),fluent.getSystem(),fluent.getVolumeName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}