package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ScopeSelectorBuilder extends ScopeSelectorFluentImpl<ScopeSelectorBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.ScopeSelector,ScopeSelectorBuilder>{
  public ScopeSelectorBuilder() {
    this(false);
  }
  public ScopeSelectorBuilder(Boolean validationEnabled) {
    this(new ScopeSelector(), validationEnabled);
  }
  public ScopeSelectorBuilder(ScopeSelectorFluent<?> fluent) {
    this(fluent, false);
  }
  public ScopeSelectorBuilder(io.fabric8.kubernetes.api.model.ScopeSelectorFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ScopeSelector(), validationEnabled);
  }
  public ScopeSelectorBuilder(io.fabric8.kubernetes.api.model.ScopeSelectorFluent<?> fluent,io.fabric8.kubernetes.api.model.ScopeSelector instance) {
    this(fluent, instance, false);
  }
  public ScopeSelectorBuilder(io.fabric8.kubernetes.api.model.ScopeSelectorFluent<?> fluent,io.fabric8.kubernetes.api.model.ScopeSelector instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withMatchExpressions(instance.getMatchExpressions()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ScopeSelectorBuilder(io.fabric8.kubernetes.api.model.ScopeSelector instance) {
    this(instance,false);
  }
  public ScopeSelectorBuilder(io.fabric8.kubernetes.api.model.ScopeSelector instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withMatchExpressions(instance.getMatchExpressions()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.ScopeSelectorFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.ScopeSelector build() {
    ScopeSelector buildable = new ScopeSelector(fluent.getMatchExpressions());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}