package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SeccompProfileBuilder extends SeccompProfileFluentImpl<SeccompProfileBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.SeccompProfile,SeccompProfileBuilder>{
  public SeccompProfileBuilder() {
    this(false);
  }
  public SeccompProfileBuilder(Boolean validationEnabled) {
    this(new SeccompProfile(), validationEnabled);
  }
  public SeccompProfileBuilder(SeccompProfileFluent<?> fluent) {
    this(fluent, false);
  }
  public SeccompProfileBuilder(io.fabric8.kubernetes.api.model.SeccompProfileFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new SeccompProfile(), validationEnabled);
  }
  public SeccompProfileBuilder(io.fabric8.kubernetes.api.model.SeccompProfileFluent<?> fluent,io.fabric8.kubernetes.api.model.SeccompProfile instance) {
    this(fluent, instance, false);
  }
  public SeccompProfileBuilder(io.fabric8.kubernetes.api.model.SeccompProfileFluent<?> fluent,io.fabric8.kubernetes.api.model.SeccompProfile instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withLocalhostProfile(instance.getLocalhostProfile()); 
    fluent.withType(instance.getType()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public SeccompProfileBuilder(io.fabric8.kubernetes.api.model.SeccompProfile instance) {
    this(instance,false);
  }
  public SeccompProfileBuilder(io.fabric8.kubernetes.api.model.SeccompProfile instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withLocalhostProfile(instance.getLocalhostProfile()); 
    this.withType(instance.getType()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.SeccompProfileFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.SeccompProfile build() {
    SeccompProfile buildable = new SeccompProfile(fluent.getLocalhostProfile(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}