package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SecretListBuilder extends SecretListFluentImpl<SecretListBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.SecretList,SecretListBuilder>{
  public SecretListBuilder() {
    this(false);
  }
  public SecretListBuilder(Boolean validationEnabled) {
    this(new SecretList(), validationEnabled);
  }
  public SecretListBuilder(SecretListFluent<?> fluent) {
    this(fluent, false);
  }
  public SecretListBuilder(io.fabric8.kubernetes.api.model.SecretListFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new SecretList(), validationEnabled);
  }
  public SecretListBuilder(io.fabric8.kubernetes.api.model.SecretListFluent<?> fluent,io.fabric8.kubernetes.api.model.SecretList instance) {
    this(fluent, instance, false);
  }
  public SecretListBuilder(io.fabric8.kubernetes.api.model.SecretListFluent<?> fluent,io.fabric8.kubernetes.api.model.SecretList instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public SecretListBuilder(io.fabric8.kubernetes.api.model.SecretList instance) {
    this(instance,false);
  }
  public SecretListBuilder(io.fabric8.kubernetes.api.model.SecretList instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.SecretListFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.SecretList build() {
    SecretList buildable = new SecretList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}