package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SecretProjectionBuilder extends SecretProjectionFluentImpl<SecretProjectionBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.SecretProjection,SecretProjectionBuilder>{
  public SecretProjectionBuilder() {
    this(false);
  }
  public SecretProjectionBuilder(Boolean validationEnabled) {
    this(new SecretProjection(), validationEnabled);
  }
  public SecretProjectionBuilder(SecretProjectionFluent<?> fluent) {
    this(fluent, false);
  }
  public SecretProjectionBuilder(io.fabric8.kubernetes.api.model.SecretProjectionFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new SecretProjection(), validationEnabled);
  }
  public SecretProjectionBuilder(io.fabric8.kubernetes.api.model.SecretProjectionFluent<?> fluent,io.fabric8.kubernetes.api.model.SecretProjection instance) {
    this(fluent, instance, false);
  }
  public SecretProjectionBuilder(io.fabric8.kubernetes.api.model.SecretProjectionFluent<?> fluent,io.fabric8.kubernetes.api.model.SecretProjection instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withItems(instance.getItems()); 
    fluent.withName(instance.getName()); 
    fluent.withOptional(instance.getOptional()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public SecretProjectionBuilder(io.fabric8.kubernetes.api.model.SecretProjection instance) {
    this(instance,false);
  }
  public SecretProjectionBuilder(io.fabric8.kubernetes.api.model.SecretProjection instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withItems(instance.getItems()); 
    this.withName(instance.getName()); 
    this.withOptional(instance.getOptional()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.SecretProjectionFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.SecretProjection build() {
    SecretProjection buildable = new SecretProjection(fluent.getItems(),fluent.getName(),fluent.getOptional());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}