package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SecretReferenceBuilder extends SecretReferenceFluentImpl<SecretReferenceBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.SecretReference,io.fabric8.kubernetes.api.model.SecretReferenceBuilder>{
  public SecretReferenceBuilder() {
    this(false);
  }
  public SecretReferenceBuilder(Boolean validationEnabled) {
    this(new SecretReference(), validationEnabled);
  }
  public SecretReferenceBuilder(SecretReferenceFluent<?> fluent) {
    this(fluent, false);
  }
  public SecretReferenceBuilder(io.fabric8.kubernetes.api.model.SecretReferenceFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new SecretReference(), validationEnabled);
  }
  public SecretReferenceBuilder(io.fabric8.kubernetes.api.model.SecretReferenceFluent<?> fluent,io.fabric8.kubernetes.api.model.SecretReference instance) {
    this(fluent, instance, false);
  }
  public SecretReferenceBuilder(io.fabric8.kubernetes.api.model.SecretReferenceFluent<?> fluent,io.fabric8.kubernetes.api.model.SecretReference instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withName(instance.getName()); 
    fluent.withNamespace(instance.getNamespace()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public SecretReferenceBuilder(io.fabric8.kubernetes.api.model.SecretReference instance) {
    this(instance,false);
  }
  public SecretReferenceBuilder(io.fabric8.kubernetes.api.model.SecretReference instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withName(instance.getName()); 
    this.withNamespace(instance.getNamespace()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.SecretReferenceFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.SecretReference build() {
    SecretReference buildable = new SecretReference(fluent.getName(),fluent.getNamespace());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}