package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SecretVolumeSourceBuilder extends SecretVolumeSourceFluentImpl<SecretVolumeSourceBuilder> implements VisitableBuilder<SecretVolumeSource,io.fabric8.kubernetes.api.model.SecretVolumeSourceBuilder>{
  public SecretVolumeSourceBuilder() {
    this(false);
  }
  public SecretVolumeSourceBuilder(Boolean validationEnabled) {
    this(new SecretVolumeSource(), validationEnabled);
  }
  public SecretVolumeSourceBuilder(io.fabric8.kubernetes.api.model.SecretVolumeSourceFluent<?> fluent) {
    this(fluent, false);
  }
  public SecretVolumeSourceBuilder(io.fabric8.kubernetes.api.model.SecretVolumeSourceFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new SecretVolumeSource(), validationEnabled);
  }
  public SecretVolumeSourceBuilder(io.fabric8.kubernetes.api.model.SecretVolumeSourceFluent<?> fluent,io.fabric8.kubernetes.api.model.SecretVolumeSource instance) {
    this(fluent, instance, false);
  }
  public SecretVolumeSourceBuilder(io.fabric8.kubernetes.api.model.SecretVolumeSourceFluent<?> fluent,io.fabric8.kubernetes.api.model.SecretVolumeSource instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withDefaultMode(instance.getDefaultMode()); 
    fluent.withItems(instance.getItems()); 
    fluent.withOptional(instance.getOptional()); 
    fluent.withSecretName(instance.getSecretName()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public SecretVolumeSourceBuilder(io.fabric8.kubernetes.api.model.SecretVolumeSource instance) {
    this(instance,false);
  }
  public SecretVolumeSourceBuilder(io.fabric8.kubernetes.api.model.SecretVolumeSource instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withDefaultMode(instance.getDefaultMode()); 
    this.withItems(instance.getItems()); 
    this.withOptional(instance.getOptional()); 
    this.withSecretName(instance.getSecretName()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.SecretVolumeSourceFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.SecretVolumeSource build() {
    SecretVolumeSource buildable = new SecretVolumeSource(fluent.getDefaultMode(),fluent.getItems(),fluent.getOptional(),fluent.getSecretName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}