package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SecurityContextBuilder extends SecurityContextFluentImpl<SecurityContextBuilder> implements VisitableBuilder<SecurityContext,io.fabric8.kubernetes.api.model.SecurityContextBuilder>{
  public SecurityContextBuilder() {
    this(false);
  }
  public SecurityContextBuilder(Boolean validationEnabled) {
    this(new SecurityContext(), validationEnabled);
  }
  public SecurityContextBuilder(SecurityContextFluent<?> fluent) {
    this(fluent, false);
  }
  public SecurityContextBuilder(io.fabric8.kubernetes.api.model.SecurityContextFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new SecurityContext(), validationEnabled);
  }
  public SecurityContextBuilder(io.fabric8.kubernetes.api.model.SecurityContextFluent<?> fluent,io.fabric8.kubernetes.api.model.SecurityContext instance) {
    this(fluent, instance, false);
  }
  public SecurityContextBuilder(io.fabric8.kubernetes.api.model.SecurityContextFluent<?> fluent,io.fabric8.kubernetes.api.model.SecurityContext instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAllowPrivilegeEscalation(instance.getAllowPrivilegeEscalation()); 
    fluent.withCapabilities(instance.getCapabilities()); 
    fluent.withPrivileged(instance.getPrivileged()); 
    fluent.withProcMount(instance.getProcMount()); 
    fluent.withReadOnlyRootFilesystem(instance.getReadOnlyRootFilesystem()); 
    fluent.withRunAsGroup(instance.getRunAsGroup()); 
    fluent.withRunAsNonRoot(instance.getRunAsNonRoot()); 
    fluent.withRunAsUser(instance.getRunAsUser()); 
    fluent.withSeLinuxOptions(instance.getSeLinuxOptions()); 
    fluent.withSeccompProfile(instance.getSeccompProfile()); 
    fluent.withWindowsOptions(instance.getWindowsOptions()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public SecurityContextBuilder(io.fabric8.kubernetes.api.model.SecurityContext instance) {
    this(instance,false);
  }
  public SecurityContextBuilder(io.fabric8.kubernetes.api.model.SecurityContext instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withAllowPrivilegeEscalation(instance.getAllowPrivilegeEscalation()); 
    this.withCapabilities(instance.getCapabilities()); 
    this.withPrivileged(instance.getPrivileged()); 
    this.withProcMount(instance.getProcMount()); 
    this.withReadOnlyRootFilesystem(instance.getReadOnlyRootFilesystem()); 
    this.withRunAsGroup(instance.getRunAsGroup()); 
    this.withRunAsNonRoot(instance.getRunAsNonRoot()); 
    this.withRunAsUser(instance.getRunAsUser()); 
    this.withSeLinuxOptions(instance.getSeLinuxOptions()); 
    this.withSeccompProfile(instance.getSeccompProfile()); 
    this.withWindowsOptions(instance.getWindowsOptions()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.SecurityContextFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.SecurityContext build() {
    SecurityContext buildable = new SecurityContext(fluent.getAllowPrivilegeEscalation(),fluent.getCapabilities(),fluent.getPrivileged(),fluent.getProcMount(),fluent.getReadOnlyRootFilesystem(),fluent.getRunAsGroup(),fluent.getRunAsNonRoot(),fluent.getRunAsUser(),fluent.getSeLinuxOptions(),fluent.getSeccompProfile(),fluent.getWindowsOptions());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}