package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ServerAddressByClientCIDRBuilder extends ServerAddressByClientCIDRFluentImpl<ServerAddressByClientCIDRBuilder> implements VisitableBuilder<ServerAddressByClientCIDR,io.fabric8.kubernetes.api.model.ServerAddressByClientCIDRBuilder>{
  public ServerAddressByClientCIDRBuilder() {
    this(false);
  }
  public ServerAddressByClientCIDRBuilder(Boolean validationEnabled) {
    this(new ServerAddressByClientCIDR(), validationEnabled);
  }
  public ServerAddressByClientCIDRBuilder(ServerAddressByClientCIDRFluent<?> fluent) {
    this(fluent, false);
  }
  public ServerAddressByClientCIDRBuilder(io.fabric8.kubernetes.api.model.ServerAddressByClientCIDRFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ServerAddressByClientCIDR(), validationEnabled);
  }
  public ServerAddressByClientCIDRBuilder(io.fabric8.kubernetes.api.model.ServerAddressByClientCIDRFluent<?> fluent,io.fabric8.kubernetes.api.model.ServerAddressByClientCIDR instance) {
    this(fluent, instance, false);
  }
  public ServerAddressByClientCIDRBuilder(io.fabric8.kubernetes.api.model.ServerAddressByClientCIDRFluent<?> fluent,io.fabric8.kubernetes.api.model.ServerAddressByClientCIDR instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withClientCIDR(instance.getClientCIDR()); 
    fluent.withServerAddress(instance.getServerAddress()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ServerAddressByClientCIDRBuilder(io.fabric8.kubernetes.api.model.ServerAddressByClientCIDR instance) {
    this(instance,false);
  }
  public ServerAddressByClientCIDRBuilder(io.fabric8.kubernetes.api.model.ServerAddressByClientCIDR instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withClientCIDR(instance.getClientCIDR()); 
    this.withServerAddress(instance.getServerAddress()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.ServerAddressByClientCIDRFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.ServerAddressByClientCIDR build() {
    ServerAddressByClientCIDR buildable = new ServerAddressByClientCIDR(fluent.getClientCIDR(),fluent.getServerAddress());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}