package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ServiceAccountBuilder extends ServiceAccountFluentImpl<ServiceAccountBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.ServiceAccount,io.fabric8.kubernetes.api.model.ServiceAccountBuilder>{
  public ServiceAccountBuilder() {
    this(false);
  }
  public ServiceAccountBuilder(Boolean validationEnabled) {
    this(new ServiceAccount(), validationEnabled);
  }
  public ServiceAccountBuilder(ServiceAccountFluent<?> fluent) {
    this(fluent, false);
  }
  public ServiceAccountBuilder(io.fabric8.kubernetes.api.model.ServiceAccountFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ServiceAccount(), validationEnabled);
  }
  public ServiceAccountBuilder(io.fabric8.kubernetes.api.model.ServiceAccountFluent<?> fluent,io.fabric8.kubernetes.api.model.ServiceAccount instance) {
    this(fluent, instance, false);
  }
  public ServiceAccountBuilder(io.fabric8.kubernetes.api.model.ServiceAccountFluent<?> fluent,io.fabric8.kubernetes.api.model.ServiceAccount instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withAutomountServiceAccountToken(instance.getAutomountServiceAccountToken()); 
    fluent.withImagePullSecrets(instance.getImagePullSecrets()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSecrets(instance.getSecrets()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ServiceAccountBuilder(io.fabric8.kubernetes.api.model.ServiceAccount instance) {
    this(instance,false);
  }
  public ServiceAccountBuilder(io.fabric8.kubernetes.api.model.ServiceAccount instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withAutomountServiceAccountToken(instance.getAutomountServiceAccountToken()); 
    this.withImagePullSecrets(instance.getImagePullSecrets()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSecrets(instance.getSecrets()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.ServiceAccountFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.ServiceAccount build() {
    ServiceAccount buildable = new ServiceAccount(fluent.getApiVersion(),fluent.getAutomountServiceAccountToken(),fluent.getImagePullSecrets(),fluent.getKind(),fluent.getMetadata(),fluent.getSecrets());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}