package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ServiceAccountListBuilder extends ServiceAccountListFluentImpl<ServiceAccountListBuilder> implements VisitableBuilder<ServiceAccountList,io.fabric8.kubernetes.api.model.ServiceAccountListBuilder>{
  public ServiceAccountListBuilder() {
    this(false);
  }
  public ServiceAccountListBuilder(Boolean validationEnabled) {
    this(new ServiceAccountList(), validationEnabled);
  }
  public ServiceAccountListBuilder(ServiceAccountListFluent<?> fluent) {
    this(fluent, false);
  }
  public ServiceAccountListBuilder(io.fabric8.kubernetes.api.model.ServiceAccountListFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ServiceAccountList(), validationEnabled);
  }
  public ServiceAccountListBuilder(io.fabric8.kubernetes.api.model.ServiceAccountListFluent<?> fluent,io.fabric8.kubernetes.api.model.ServiceAccountList instance) {
    this(fluent, instance, false);
  }
  public ServiceAccountListBuilder(io.fabric8.kubernetes.api.model.ServiceAccountListFluent<?> fluent,io.fabric8.kubernetes.api.model.ServiceAccountList instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ServiceAccountListBuilder(io.fabric8.kubernetes.api.model.ServiceAccountList instance) {
    this(instance,false);
  }
  public ServiceAccountListBuilder(io.fabric8.kubernetes.api.model.ServiceAccountList instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.ServiceAccountListFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.ServiceAccountList build() {
    ServiceAccountList buildable = new ServiceAccountList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}