package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ServiceBuilder extends ServiceFluentImpl<ServiceBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.Service,io.fabric8.kubernetes.api.model.ServiceBuilder>{
  public ServiceBuilder() {
    this(false);
  }
  public ServiceBuilder(Boolean validationEnabled) {
    this(new Service(), validationEnabled);
  }
  public ServiceBuilder(ServiceFluent<?> fluent) {
    this(fluent, false);
  }
  public ServiceBuilder(io.fabric8.kubernetes.api.model.ServiceFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new Service(), validationEnabled);
  }
  public ServiceBuilder(io.fabric8.kubernetes.api.model.ServiceFluent<?> fluent,io.fabric8.kubernetes.api.model.Service instance) {
    this(fluent, instance, false);
  }
  public ServiceBuilder(io.fabric8.kubernetes.api.model.ServiceFluent<?> fluent,io.fabric8.kubernetes.api.model.Service instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withStatus(instance.getStatus()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ServiceBuilder(io.fabric8.kubernetes.api.model.Service instance) {
    this(instance,false);
  }
  public ServiceBuilder(io.fabric8.kubernetes.api.model.Service instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.ServiceFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.Service build() {
    Service buildable = new Service(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}